package com.mmc.iuav.user.entity.dronepilot;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/7/28 10:38
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PilotCertificationLogDO {


    @ApiModelProperty(value = "id", example = "1")
    private Integer id;
    @ApiModelProperty(value = "审批及认证时间", example = "1")
    private Date certificationDate;
    @ApiModelProperty(value = "申请人员的id", example = "1")
    private Integer userAccountId;
    @ApiModelProperty(value = "申请及审批信息", example = "1")
    private String certificationMessage;
    @ApiModelProperty(value = "操作人员id", example = "1")
    private Integer operatorUserId;


    public PilotCertificationLogDO(PilotCertificationDO pilotCertificationDO, CertificationMessage certificationMessage) {
        this.userAccountId = pilotCertificationDO.getUserAccountId();
        this.certificationMessage = certificationMessage.getMessage();

    }

}
