package com.mmc.iuav.user;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.web.client.RestTemplate;
/**
 * @author:zhenjie
 * @Date:2023/5/15 15:35
 */
@EnableScheduling
@SpringBootApplication
@EnableFeignClients(basePackages = "com.mmc.iuav.user.feign") // 所有FeignClient放在client-feign-springboot-starter里面进行管理
public class UserApplication {
    public static void main(String[] args) {
        SpringApplication.run(UserApplication.class, args);
    }

    @Bean
    public RestTemplate restTemplate() {
        return new RestTemplate();
    }
}
