package com.mmc.iuav.user.entity.wallet;

import com.mmc.iuav.user.enums.RebateMethod;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @Author LW
 * @date 2023/8/24 14:37
 * 概要：
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class UserBillingDetailVO implements Serializable {
    private static final long serialVersionUID = -113701726830167312L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "流水编号")
    private String payNo;
    @ApiModelProperty(value = "操作方式")
    private Integer payMethod;
    @ApiModelProperty(value = "云享金变动金额(正数充值，负数扣除)")
    private BigDecimal cashAmtPaid;
    @ApiModelProperty(value = "佣金变动金额(正数入账，负数扣除)")
    private BigDecimal salaryAmtPaid;
    @ApiModelProperty(value = "操作时间")
    private Date payTime;
    @ApiModelProperty(value = "操作名称")
    private String name;
    @ApiModelProperty(value = "到账账户")
    private String account;
    @ApiModelProperty(value = "处理进度")
    private List<Schedule> schedules;

    public void buildSchedules(List<WithdrawalLogDO> list) {
        this.schedules = new ArrayList<Schedule>();

        for (WithdrawalLogDO d : list) {

            if (RebateMethod.PENDING.getCode().equals(d.getPayMethod().toString())) {
                Schedule sd = new Schedule();
                sd.setTitle(RebateMethod.PENDING.getStatus());
                sd.setAcTime(d.getPayTime());
                sd.setActive(1);
                this.schedules.add(sd);
            } else if (RebateMethod.SUCCESS.getCode().equals(d.getPayMethod().toString())) {
                Schedule sd = new Schedule();
                sd.setTitle(RebateMethod.SUCCESS.getStatus());
                sd.setAcTime(d.getPayTime());
                sd.setActive(1);
                this.schedules.add(sd);
            } else if (RebateMethod.FAIL.getCode().equals(d.getPayMethod().toString())) {
                Schedule sd = new Schedule();
                sd.setTitle(RebateMethod.FAIL.getStatus());
                sd.setAcTime(d.getPayTime());
                sd.setActive(1);
                this.schedules.add(sd);
            }
        }
        if (this.schedules.size() == 1) {
            Schedule sd = new Schedule();
            sd.setTitle(RebateMethod.SUCCESS.getStatus());
            sd.setActive(0);
            this.schedules.add(sd);
        }
    }

    public static class Schedule {
        private String title;
        private Date acTime;
        private Integer active;

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Date getAcTime() {
            return acTime;
        }

        public void setAcTime(Date acTime) {
            this.acTime = acTime;
        }

        public Integer getActive() {
            return active;
        }

        public void setActive(Integer active) {
            this.active = active;
        }
    }

}
