package com.mmc.iuav.user.model.dto.wallet;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author 作者 lw
 * @version 创建时间：2023.08.18 下午13:31:12
 * @explain 类说明
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PayWalletDTO implements Serializable {
    private static final long serialVersionUID = 75097833899496576L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "用户ID")
    private Integer userAccountId;
    @ApiModelProperty(value = "用户姓名")
    private String userName;
    @ApiModelProperty(value = "云享金余额")
    private BigDecimal cashAmt;
    @ApiModelProperty(value = "云享金总金额")
    private BigDecimal totalCash;
    @ApiModelProperty(value = "已冻结云享金")
    private BigDecimal cashFreeze;
    @ApiModelProperty(value = "佣金余额")
    private BigDecimal salaryAmt;
    @ApiModelProperty(value = "已冻结佣金")
    private BigDecimal salaryFreeze;
    @ApiModelProperty(value = "佣金总额度")
    private BigDecimal totalSalary;
    @ApiModelProperty(value = "已提现的金额")
    private BigDecimal rebateWdl;
    @ApiModelProperty(value = "冻结总额")
    private BigDecimal totalFreeze;
    @ApiModelProperty(value = "总金额")
    private BigDecimal totalAmount;

    public void mathTotal() {
        // 总冻结余额
        this.totalFreeze = BigDecimal.ZERO;
        if (this.cashFreeze != null) {
            this.totalFreeze = this.totalFreeze.add(this.cashFreeze);
        }
        if (this.salaryFreeze != null) {
            this.totalFreeze = this.totalFreeze.add(this.salaryFreeze);
        }

        // 总云享金余额
        this.totalCash = BigDecimal.ZERO;
        if (this.cashAmt != null) {
            this.totalCash = this.totalCash.add(this.cashAmt);
        }
        if (this.cashFreeze != null) {
            this.totalCash = this.totalCash.add(this.cashFreeze);
        }

        // 总佣金余额
        this.totalSalary = BigDecimal.ZERO;
        if (this.salaryAmt != null) {
            this.totalSalary = this.totalSalary.add(this.salaryAmt);
        }
        if (this.salaryFreeze != null) {
            this.totalSalary = this.totalSalary.add(this.salaryFreeze);
        }

        // 总金额
        this.totalAmount = BigDecimal.ZERO;
        this.totalAmount = this.totalAmount.add(this.totalCash);
        this.totalAmount = this.totalAmount.add(this.totalSalary);
    }
}
