package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.UserAccountDO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 19:26
 */
@Mapper
public interface UserServiceDao {
    /**
     * 根据用户unionId查询用户信息
     * @param unionId
     * @return
     */
    UserAccountDO getUserAccountInfoByUnionId(String unionId);

    /**
     * 插入用户信息
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);

    /**
     * 根据用户id查询用户信息
     * @param userAccountId
     * @return
     */
    UserAccountDO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     * @param userAccountDO
     */
    void update(UserAccountDO userAccountDO);

    /**
     * 根据用户地区查询后台用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> listUserAccountIdsByDistrictCode(Integer provinceCode, Integer cityCode, Integer districtCode);
}
