package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/5/16 17:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserAccountDO implements Serializable {
    private static final long serialVersionUID = 5007589179946146721L;
    private Integer id;
    private Integer accountType;
    private String uid;
    private String phoneNum;
    private String userName;
    private String nickName;
    private String userImg;
    private String openId;
    private String unionId;
    private Integer userSex;
    private String email;
    private Integer source;
    private Integer accountStatus;
    private String remark;
    private Integer portType;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;

    public UserAccountDO(UserAccountVO userAccountVO) {
        this.id = userAccountVO.getId();
        this.phoneNum = userAccountVO.getPhoneNum();
        this.userName = userAccountVO.getUserName();
        this.nickName = userAccountVO.getNickName();
        this.userImg = userAccountVO.getUserImg();
        this.userSex = userAccountVO.getUserSex();
        this.email = userAccountVO.getEmail();
        this.accountStatus = userAccountVO.getAccountStatus();
        this.remark = userAccountVO.getRemark();
        this.portType = userAccountVO.getPortType();
    }

    public UserAccountVO buildUserAccountVO() {
        return UserAccountVO.builder().id(this.id).uid(this.uid).accountType(this.accountType).phoneNum(this.phoneNum).userName(this.userName).nickName(this.nickName)
                .userImg(this.userImg).userSex(this.userSex).email(this.email).source(this.source).accountStatus(this.accountStatus).remark(this.remark).portType(this.portType)
                .createTime(this.createTime).build();
    }

    public UserAccountSimpleDTO buildUserAccountSimpleDTO() {
        return UserAccountSimpleDTO.builder().id(this.id).uid(this.uid).accountType(this.accountType).phoneNum(this.phoneNum).userName(this.userName).nickName(this.nickName)
              .userImg(this.userImg).userSex(this.userSex).email(this.email).source(this.source).accountStatus(this.accountStatus).portType(this.portType)
              .build();
    }
}
