package com.mmc.iuav.user.model.qo;

import com.mmc.iuav.group.Page;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.List;

/**
 * author:zhenjie
 * Date:2021/10/27
 * time:20:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(description = "实名认证查询QO")
public class RealNameAuthQO implements Serializable {
    private static final long serialVersionUID = 3767938308251944541L;

    @ApiModelProperty(value = "关键字")
    private String keyword;

    @ApiModelProperty(value = "地区", hidden = true)
    private String area;

    @ApiModelProperty(value = "实名认证状态", hidden = true)
    private Integer checkStatus;

    @ApiModelProperty(value = "单位id集合", hidden = true)
    private List<Integer> companyIds;

    @ApiModelProperty(value = "页码", required = true)
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true)
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }

}
