package com.mmc.iuav.user.entity.fdd;

import com.mmc.iuav.user.model.fdd.dto.ContractInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * (ContractInfoDO)实体类
 *
 * @author makejava
 * @since 2023-09-07 10:14:08
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ContractInfoDO implements Serializable {
    private static final long serialVersionUID = -42558889792167148L;

    private Integer id;
    /**
     * 发起合同方用户id
     */
    private String unionId;
    /**
     * 订单号
     */
    private String orderNo;
    /**
     * 合同编号
     */
    private String contractNo;
    /**
     * 合同标题
     */
    private String contractTitle;
    /**
     * 状态： 0、等待平台签署1、平台签署失败 2、等待（买家/供应商）签署（平台签署成功） 3、（买家/供应商）签署失败 4、（买家/供应商）签署成功、5、归档
     */
    private Integer signStatus;
    /**
     * 签署完成日期
     */
    private Date singerTime;
    /**
     * 平台签署失败备注信息
     */
    private String aRemark;
    /**
     * （买家/供应商）签署失败备注信息
     */
    private String bRemark;
    /**
     * 平台签署交易号
     */
    private String aTransactionId;
    /**
     * （买家/供应商）签署交易号
     */
    private String bTransactionId;

    private Date createTime;

    private Date updateTime;
    /**
     * 归档日期
     */
    private Date archiveDate;

    public ContractInfoDTO buildContractInfoDTO() {
        return ContractInfoDTO.builder().id(this.id).unionId(this.unionId).orderNo(this.orderNo).contractNo(this.contractNo).contractTitle(this.contractTitle)
                .signStatus(this.signStatus).singerTime(this.singerTime).aRemark(this.aRemark).bRemark(this.bRemark).aTransactionId(this.aTransactionId).bTransactionId(this.bTransactionId)
                .createTime(this.createTime).updateTime(this.updateTime).archiveDate(this.archiveDate).build();
    }
}

