package com.mmc.iuav.user.entity.dronepilot;

import com.mmc.iuav.group.Update;
import com.mmc.iuav.user.model.dto.dronepilot.PilotReasonDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

/**
 * @Author small
 * @Date 2023/8/3 16:29
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PilotReasonDO {
    @ApiModelProperty(value = "原因id", example = "1")
    @NotNull(message = "原因id", groups = Update.class)
    private Integer id;

    @ApiModelProperty(value = "原因", example = "请提供有效期内的执照")
    private String reason;


    public PilotReasonDTO buildPilotReasonDTO() {
        return PilotReasonDTO.builder()
                .id(this.id)
                .reason(this.reason)
                .build();
    }


}
