package com.mmc.iuav.user.service.wallet;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.wallet.CurriculumOrderLogVO;
import com.mmc.iuav.user.model.qo.wallet.WalletFlowQO;
import com.mmc.iuav.user.model.vo.wallet.PayUavWalletVO;
import com.mmc.iuav.user.model.vo.wallet.TopUpOrderVO;
import com.mmc.iuav.user.model.vo.wallet.WalletFlowVO;

/**
 * @Author LW
 * @date 2023/8/18 11:36
 * 概要：
 */
public interface PayWalletService {
    ResultBody getPayWalletInfo(Integer userAccountId);

    ResultBody initPayWallet(Integer userAccountId);

    ResultBody feignWalletFlow(WalletFlowVO walletFlowVO);

    ResultBody feignTopUpCash(TopUpOrderVO topUpOrderVO);

    ResultBody customerBillingDetail(Integer userAccountId, WalletFlowQO walletFlowQO);

    ResultBody billingDetails(Integer id, String detailType);

    ResultBody payUavWallet(PayUavWalletVO payUavWalletVO);

    /**
     * 保存用户购买课程消耗的云享金和佣金的金额流水
     * @param param
     * @return {@link ResultBody}
     */
    ResultBody feignCurriculumOrderLog(Integer userId, CurriculumOrderLogVO param);

    ResultBody optimizeWalletFlow(WalletFlowVO walletFlowVO);
}
