package com.mmc.iuav.user.dao.wallet;

import com.mmc.iuav.user.entity.XzWithdrawalApplyDO;
import com.mmc.iuav.user.entity.wallet.PayLogDO;
import com.mmc.iuav.user.entity.wallet.PayWalletDO;
import com.mmc.iuav.user.entity.wallet.WithdrawalLogDO;
import com.mmc.iuav.user.model.qo.wallet.WalletFlowQO;
import com.mmc.iuav.user.model.qo.wallet.WithdrawalApplyQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @Author LW
 * @date 2023/8/18 11:37
 * 概要：
 */
@Mapper
public interface PayWalletDao {
    PayWalletDO getPayWalletByUser(Integer userAccountId);

    void insertPayWalletInfo(PayWalletDO wallet);

    void insertPayLogDO(PayLogDO payWalletDO);

    int updatePayWallet(PayWalletDO updatePayWallet);

    List<PayLogDO> getPayLog(WalletFlowQO param);

    int countPayLog(WalletFlowQO param);

    PayLogDO getPayLogById(Integer id);

    void insertWithdrawalLog(WithdrawalLogDO withdrawalLogDO);

    List<XzWithdrawalApplyDO> getWithdrawalListByUserAccountId(WalletFlowQO param);

    XzWithdrawalApplyDO getWithdrawalApplyByIdOrOuterTradeNo(@Param(value = "id") Integer id, @Param(value = "outerTradeNo") String outerTradeNo);

    List<WithdrawalLogDO> listPayWithdrawalLog(Integer id);

    int countPayWithdrawalLog(WalletFlowQO param);

    int countWithdrawalApply(WithdrawalApplyQO param);

    List<XzWithdrawalApplyDO> listPageWithdrawalApply(WithdrawalApplyQO param);

    int updateWithdrawalApply(XzWithdrawalApplyDO apply);
}
