package com.mmc.iuav.user.controller.data;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.data.ProductReportDTO;
import com.mmc.iuav.user.model.dto.data.UserReportDTO;
import com.mmc.iuav.user.service.data.UserReportService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

/**
 * @Author LW
 * @date 2023/9/16 11:25
 * 概要：
 */
@Api(tags = "云享飞发数据看板")
@RequestMapping("/user/report")
@RestController
public class UserReportController {

    @Autowired
    private UserReportService userReportService;

    @ApiOperation(value = "获取用户报表数据")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = UserReportDTO.class)})
    @GetMapping("/getUserReportData")
    public ResultBody<UserReportDTO> getUserReportData(@ApiParam(value = "（预留字段暂时不传值）根据时间查询（暂未实现）") @RequestParam(required = false) String date) {
        return userReportService.getUserReportData(date);
    }

    @ApiOperation(value = "获取入驻商家数量")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ProductReportDTO.class)})
    @GetMapping("/getJoinStoreNumber")
    @ApiIgnore
    public ProductReportDTO getJoinStoreNumber() {
        return userReportService.getJoinStoreNumber();
    }
}
