package com.mmc.iuav.user.service.xzsz.impl;

import cn.hutool.json.JSONObject;
import com.mmc.iuav.http.HttpsRequestUtil;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.constant.UserSystemConstant;
import com.mmc.iuav.user.dao.xzsz.XzDao;
import com.mmc.iuav.user.entity.XzAuthDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.vo.XzAuthVO;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.XzService;
import com.piggy.settlement.sdk.client.sign.PiggySignApiClient;
import com.piggy.settlement.sdk.client.v2.basics.PiggyOpenBasicsClient;
import com.piggy.settlement.sdk.client.v2.singlewithdraw.PiggySingleWithdrawalApiV2Client;
import com.piggy.settlement.sdk.util.v2.PiggyOpenBasicsAesUtil;
import com.piggy.settlement.sdk.vo.sign.PiggySignResultVo;
import com.piggy.settlement.sdk.vo.sign.PiggySignVo;
import com.piggy.settlement.sdk.vo.v2.basics.PiggyBasicsVo;
import com.piggy.settlement.sdk.vo.v2.singlewithdraw.PiggySingleWithdrawV2Vo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: zj
 * @Date: 2023/8/21 9:52
 */
@Service
@Slf4j
public class XzServiceImpl implements XzService {
    @Autowired
    private UserSystemConstant userSystemConstant;

    @Autowired
    private XzDao xzDao;

    @Override
    public ResultBody getTaxFundList() {
        PiggyOpenBasicsClient piggyOpenBasicsClient = PiggyOpenBasicsClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyOpenBasicsClient.getTaxFundList(PiggyBasicsVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .build());
        return ResultBody.success(jsonObject.get("data"));
    }

    @Override
    public ResultBody getCashPooling() {
        PiggyOpenBasicsClient piggyOpenBasicsClient = PiggyOpenBasicsClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyOpenBasicsClient.getCashPooling(PiggyBasicsVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success(jsonObject.get("data"));
    }

    @Override
    public ResultBody xzService() {
        PiggyOpenBasicsClient piggyOpenBasicsClient = PiggyOpenBasicsClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyOpenBasicsClient.getTaxFundCashPooling(PiggyBasicsVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .taxFundID("8ae605f565884a1f9a5e91d5a661ce58")
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success(jsonObject.get("data"));
    }

    @Override
    public JSONObject getContractScope(XzAuthVO xzAuthVO) {
        PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggySignApiClient.getSignStatus(PiggySignResultVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .idCardNo(xzAuthVO.getIdCardNo())
                .userName(xzAuthVO.getUsername())
                .position(userSystemConstant.getXzPosition())
                .build());
        System.out.println(jsonObject.toString());
        return jsonObject;
    }

    @Override
    public String hasKeyByUrl(XzAuthVO xzAuthVO, LoginSuccessDTO loginSuccessDTO) {
        // TODO 查询是否已认证
        JSONObject contractScope = this.getContractScope(xzAuthVO);
        if (contractScope.get("data") != null) {
            xzDao.updateAuthStatus(loginSuccessDTO.getUserAccountId());
            // TODO 添加认证结果
            return "合同签署完毕";
        } else {
            Map<String, Integer> userInfo = new HashMap<String, Integer>();
            userInfo.put("userAccountId", loginSuccessDTO.getUserAccountId());
            PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
            JSONObject jsonObject = piggySignApiClient.getSignUrl(PiggySignVo.builder()
                    .appKey(userSystemConstant.getXzAppKey())
                    .customParams(com.alibaba.fastjson2.JSONObject.toJSONString(userInfo))
                    .idCardNo(xzAuthVO.getIdCardNo())
                    .infoSource("1")
                    .jumpPage("https://wwww.baidu.com")
                    .mobile(xzAuthVO.getMobile())
                    .notifyUrl("https://www.iuav.shop/xz/xzAuthNotify")
                    .position(userSystemConstant.getXzPosition())
                    .userName(xzAuthVO.getUsername())
                    .build());
            // TODO 发送模板消息
            return jsonObject.get("data").toString();
        }
    }

    @Transactional
    @Override
    public String xzAuthNotify(JSONObject notify) {
        log.info("获取到的推送结果：{}", notify.toString());
        // 认证成功，修改认证状态
        if (notify.get("code").equals("0")) {
            XzAuthDO authDO = notify.get("data", XzAuthDO.class);
            Integer userAccountId = (Integer) com.alibaba.fastjson2.JSONObject.parseObject(authDO.getCustomParams()).get("userAccountId");
            if (userAccountId != null) {
                XzAuthDO xzAuthDO = xzDao.getXzAuthByUserAccountId(userAccountId);
                if (xzAuthDO != null) {
                    authDO.setUserAccountId(userAccountId);
                    xzDao.addAuth(authDO);
                    xzDao.updateAuthStatus(userAccountId);
                    return "success";
                }
            }
        }
        return null;
    }

    @Override
    public String getSignedResult(XzAuthVO xzAuthVO) {
        PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggySignApiClient.getSignResult(PiggySignResultVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .idCardNo(xzAuthVO.getIdCardNo())
                .userName(xzAuthVO.getUsername())
                .build());
        System.out.println(jsonObject.toString());
        return jsonObject.toString();
    }

    @Override
    public String viewContract(String documentId) {
        PiggySignApiClient piggySignApiClient = PiggySignApiClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggySignApiClient.viewContract(documentId);
        System.out.println(jsonObject.toString());
        return jsonObject.toString();
    }

    @Override
    public ResultBody clearTestFace(String name, String idCard) {
        Map<String, String> map = new HashMap<String, String>();
        map.put("name", name);
        map.put("idCard", idCard);
        String s = HttpsRequestUtil.httpsGet("https://uat.xzsz.ltd/contract/sign/clearTestPerson", map);
        return ResultBody.success(s);
    }

    @Override
    public ResultBody singleSubmit(XzWithdrawalVO xzWithdrawalVO, LoginSuccessDTO loginSuccessDTO) {
        XzAuthDO xzAuthDO = xzDao.getXzAuthByUserAccountId(loginSuccessDTO.getUserAccountId());
        if (xzAuthDO == null) {
            return ResultBody.error("未认证");
        }
        // 判断自己可以提现的余额
        ResultBody resultBody = this.xzService();

        // 判断可提现金额
        PiggySingleWithdrawalApiV2Client v2Client = PiggySingleWithdrawalApiV2Client.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = v2Client.singleSubmit(PiggySingleWithdrawV2Vo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .bizAESContent(PiggyOpenBasicsAesUtil.produceAesData(userSystemConstant.getXzAppKey(), "0000000000000000", PiggySingleWithdrawV2Vo.SingleWithdrawV2Vo.builder()
                        .notifyUrl("http://www.iuav.shop/xz/xzWithdrawNotify")
                        .taxFundId(userSystemConstant.getTaxFundId())
                        .month("2021-08")
                        .outerTradeNo("TEST-123154631531345435")
                        .empNum("userAccountId_" + loginSuccessDTO.getUserAccountId())
                        .empName(xzAuthDO.getName())
                        .empPhone(xzAuthDO.getMobile())
                        .licenseType("ID_CARD")
                        .licenseId(xzAuthDO.getIdCardNo())
                        .settleType("bankcard")
                        .payAccount(xzWithdrawalVO.getPayAccount())
                        .positionName(userSystemConstant.getXzPosition())
                        .payAmount(xzWithdrawalVO.getPayAmount())
                        .bankRemo("云享飞提现")
                        .remarks("云享飞提现")
                        .build()))
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success();
    }
}
