package com.mmc.iuav.user.controller.xzsz;

import cn.hutool.json.JSONObject;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.constant.UserSystemConstant;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.vo.XzAuthVO;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.XzService;
import com.piggy.settlement.sdk.client.v2.bankreceipt.PiggyBankReceiptClient;
import com.piggy.settlement.sdk.client.v2.singlewithdraw.PiggySingleWithdrawalApiV2Client;
import com.piggy.settlement.sdk.util.v2.PiggyOpenBasicsAesUtil;
import com.piggy.settlement.sdk.vo.v2.bankreceipt.PiggyBankReceiptVo;
import com.piggy.settlement.sdk.vo.v2.singlewithdraw.PiggySingleWithdrawV2Vo;
import com.piggy.settlement.sdk.vo.v2.singlewithdraw.PiggySingleWithdrawalQueryV2Vo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/8/20 14:01
 */
@Slf4j
@Api(tags = "小猪算账api")
@RequestMapping("/xz/")
@RestController
public class XzController extends BaseController {

    @Autowired
    private XzService xzService;

    @Autowired
    private UserSystemConstant userSystemConstant;

    @ApiOperation(value = "税源地公司信息查询-V2")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getTaxFundList")
    public ResultBody getTaxFundList() {
        return xzService.getTaxFundList();
    }

    @ApiOperation(value = "资金池汇总余额查询-V2")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getCashPooling")
    public ResultBody getCashPooling() {
        return xzService.getCashPooling();
    }

    @ApiOperation(value = "查询税源地可用资金-V2")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getUsableCashPooling")
    public ResultBody getUsableCashPooling() {
        return xzService.xzService();
    }

    @ApiOperation(value = "签约状态查询")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getContractScope")
    public ResultBody getContractScope(@RequestBody XzAuthVO xzAuthVO) {
        return ResultBody.success(xzService.getContractScope(xzAuthVO));
    }

    @ApiOperation(value = "发起合同签署")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("hasKeyByUrl")
    public ResultBody hasKeyByUrl(@RequestBody XzAuthVO xzAuthVO, HttpServletRequest request) {
        return ResultBody.success(xzService.hasKeyByUrl(xzAuthVO, this.getUserLoginInfoFromRedis(request)));
    }

    @ApiOperation(value = "查询签署结果")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getSignedResult")
    public ResultBody getSignedResult(@RequestBody XzAuthVO xzAuthVO) {
        return ResultBody.success(xzService.getSignedResult(xzAuthVO));
    }

    @ApiOperation(value = "在线浏览合同")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("viewContract")
    public ResultBody viewContract(@RequestParam String documentId) {
        return ResultBody.success(xzService.viewContract(documentId));
    }

    @ApiOperation(value = "刷脸数据删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("clearTestFace")
    public ResultBody clearTestFace(@RequestParam String name, @RequestParam String idCard) {
        return xzService.clearTestFace(name, idCard);
    }

    @ApiOperation(value = "特殊单笔提现上报")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("singleSubmitLimit")
    public ResultBody singleSubmitLimit() {
        PiggySingleWithdrawalApiV2Client v2Client = PiggySingleWithdrawalApiV2Client.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = v2Client.singleSubmitLimit(PiggySingleWithdrawV2Vo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .bizAESContent(PiggyOpenBasicsAesUtil.produceAesData(userSystemConstant.getXzAppKey(), "0000000000000000", PiggySingleWithdrawV2Vo.SingleWithdrawV2Vo.builder()
                        .notifyUrl("http://uat.com")
                        .taxFundId("xxxxxxxxxxxxxxxxxxxxxxx")
                        .month("2021-03")
                        .outerTradeNo("TEST-123154631531345435")
                        .empNum("007")
                        .empName("张三")
                        .empPhone("13888886666")
                        .licenseType("ID_CARD")
                        .licenseId("110000200010102424")
                        .settleType("alipay")
                        .payAccount("13888886666@alipy.com")
                        .positionName("销售推广")
                        .payAmount(0.01)
                        .bankRemo("提现测试")
                        .build()))
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success();
    }

    @ApiOperation(value = "单笔提现上报")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("singleSubmit")
    public ResultBody singleSubmit(@RequestBody XzWithdrawalVO xzWithdrawalVO, HttpServletRequest request) {
        return xzService.singleSubmit(xzWithdrawalVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "查询提现结果")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("querySingleTrade")
    public ResultBody querySingleTrade() {
        PiggySingleWithdrawalApiV2Client v2Client = PiggySingleWithdrawalApiV2Client.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = v2Client.querySingleTrade(PiggySingleWithdrawalQueryV2Vo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .outerTradeNo("TEST-123154631531345435")
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success();
    }

    @ApiOperation(value = "查询单笔交易回单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("querySingleReceipt")
    public ResultBody querySingleReceipt() {
        PiggyBankReceiptClient piggyBankReceiptClient = PiggyBankReceiptClient.getInstanse(userSystemConstant.getXzAppSecret(), userSystemConstant.getXzDomain());
        JSONObject jsonObject = piggyBankReceiptClient.getSingleReceipt(PiggyBankReceiptVo.builder()
                .appKey(userSystemConstant.getXzAppKey())
                .frontLogNo("xxx")
                .build());
        System.out.println(jsonObject.toString());
        return ResultBody.success();
    }

    @ApiOperation(value = "签署结果回调")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("xzAuthNotify")
    public String xzAuthNotify(@RequestBody JSONObject notify) {
        return xzService.xzAuthNotify(notify);
    }

    @ApiOperation(value = "回调通知（单笔）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("xzWithdrawNotify")
    public String xzWithdrawNotify(@RequestBody JSONObject notify) {
        log.info("获取到的推送结果：{}", notify.toString());
        return "success";
    }

}
