package com.mmc.iuav.user.controller.wallet;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.wallet.PayWalletDTO;
import com.mmc.iuav.user.service.wallet.PayWalletService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2023/8/18 11:33
 * 概要：
 */
@Api(tags = "V1.0.3-用户钱包-相关接口")
@RequestMapping("/pay/")
@RestController
public class PayWalletController extends BaseController {

    @Resource
    PayWalletService payWalletService;

    @ApiOperation(value = "获取当前用户消费(钱包)信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayWalletDTO.class)})
    @GetMapping("getCurrentUserPayWalletInfo")
    public ResultBody getCurrentUserPayWalletInfo(HttpServletRequest request) {
        return payWalletService.getPayWalletInfo(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "获取用户消费(钱包)信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PayWalletDTO.class)})
    @GetMapping("getPayWalletInfo")
    public ResultBody getPayWalletInfo(
            @ApiParam(value = "用户userAccountId", required = true) @RequestParam Integer userAccountId) {
        return ResultBody.success(payWalletService.getPayWalletInfo(userAccountId));
    }

    @ApiOperation(value = "feign-初始化钱包")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @ApiIgnore
    @GetMapping("feignInitPayWallet")
    public ResultBody feignInitPayWallet(@RequestParam Integer userAccountId) {
        return payWalletService.initPayWallet(userAccountId);
    }

}
