package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.group.UpdatePassword;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.BackUserSuggestionDO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;
import com.mmc.iuav.user.model.vo.BusinessCaseVO;
import com.mmc.iuav.user.model.vo.NewMessageVO;
import com.mmc.iuav.user.service.BackUserAccountService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/25 11:22
 */
@Api(tags = "后台用户相关接口")
@RequestMapping("/back-user/")
@RestController
public class BackUserAccountController extends BaseController {

    @Autowired
    private BackUserAccountService backUserAccountService;

    @ApiOperation(value = "账号-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertBAccount")
    public ResultBody insertBAccount(@Validated(value = {Create.class}) @RequestBody BUserAccountVO bUserAccountVO,
                                     HttpServletRequest request) {
        return backUserAccountService.insertBAccount(bUserAccountVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "账号-修改")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateBAccount")
    public ResultBody updateBAccount(@Validated(value = {Update.class}) @RequestBody BUserAccountVO bUserAccountVO, HttpServletRequest request) {
        return backUserAccountService.updateBAccount(bUserAccountVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "账号-禁用（原删除）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeBAccount")
    public ResultBody disableBAccount(@RequestParam Integer userAccountId, HttpServletRequest request) {
        return backUserAccountService.disableBAccount(userAccountId, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "账号-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listBAccountPage")
    public ResultBody<BackUserAccountVO> listBAccountPage(@ApiParam(value = "账号查询QO", required = true) @RequestBody BUserAccountQO bUserAccountQO,
                                                          HttpServletRequest request) {
        return backUserAccountService.listBAccountPage(bUserAccountQO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "账号-后台用户列表-内部调用", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = List.class)})
    @PostMapping("feignListBAccountPage")
    public List<BackUserAccountVO> feignListBAccountPage(@ApiParam(value = "账号查询QO", required = true) @RequestBody BUserAccountQO bUserAccountQO) {
        return backUserAccountService.feignListBAccountPage(bUserAccountQO);
    }

    @ApiOperation(value = "账号管理-修改密码")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePassword")
    public ResultBody updatePassword(@Validated(value = {UpdatePassword.class}) @RequestBody BUserAccountVO account, HttpServletRequest request) {
        return backUserAccountService.updatePassword(account, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "feign-验证用户密码")
    @ApiIgnore
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("feignAuthUserPwd")
    public ResultBody feignAuthUserPwd(@RequestParam(required = true) Integer id,
                                       @RequestParam(required = true) String authPwd) {
        return backUserAccountService.feignAuthUserPwd(id, authPwd);
    }

    @ApiOperation(value = "pc后台-获取后台用户信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getBackUserAccountById")
    public ResultBody getBackUserAccountById(@RequestParam(required = true) Integer id) {
        return ResultBody.success(backUserAccountService.getBackUserAccountById(id));
    }


    @ApiOperation("后台——消息提示")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = NewMessageVO.class)})
    @GetMapping("getMessage")
    public ResultBody getMessage(HttpServletRequest request) {
        return backUserAccountService.getMessage(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation("后台--添加(修改)后台用户建议")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateSuggestion")
    public ResultBody updateSuggestion(@RequestBody BackUserSuggestionDO backUserSuggestionDO, HttpServletRequest request) {
        return backUserAccountService.insertCompanySuggestion(backUserSuggestionDO,this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation("后台--获取后台用户建议")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getSuggestion")
    public ResultBody getSuggestion(@RequestParam Integer backUserId) {
        return backUserAccountService.getSuggestion(backUserId);
    }

    @ApiOperation("后台--删除后台用户建议")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteSuggestion")
    public ResultBody deleteSuggestion(@RequestParam Integer id) {
        return backUserAccountService.deleteSuggestion(id);
    }


    @ApiOperation("添加业务案例")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertBusinessCase")
    public ResultBody insertBusinessCase(@RequestBody BusinessCaseVO businessCaseVo, HttpServletRequest request) {
        Integer backUserId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        businessCaseVo.setBackUserId(backUserId);
        return backUserAccountService.insertBusinessCase(businessCaseVo);
    }

    @ApiOperation("查询业务案例通过backUserId")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("getBusinessCase")
    public ResultBody getBusinessCase(@RequestParam Integer backUserId) {
        return backUserAccountService.getBusinessCase(backUserId);
    }

    @ApiOperation("删除业务案例通过backUserId")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("deleteBusinessCase")
    public ResultBody deleteBusinessCase(@RequestParam Integer backUserId) {
        return backUserAccountService.deleteBusinessCase(backUserId);
    }


}
