package com.mmc.iuav.user.controller.dronepilot;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Page;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.RoleInfoDTO;
import com.mmc.iuav.user.model.dto.dronepilot.*;
import com.mmc.iuav.user.model.qo.dronepilot.PilotAuditStatusQO;
import com.mmc.iuav.user.model.qo.dronepilot.PilotCertificationLogQO;
import com.mmc.iuav.user.model.qo.dronepilot.PilotCertificationQO;
import com.mmc.iuav.user.model.qo.dronepilot.PilotRemarkQO;
import com.mmc.iuav.user.model.vo.PilotAuditSumVO;
import com.mmc.iuav.user.model.vo.dronepilot.PilotCertificationVO;
import com.mmc.iuav.user.service.dronepilot.PilotCertificationService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/7/28 9:32
 * @Version 1.0
 */
@Api(tags = "飞手执照能力及认证")
@RequestMapping("/pilot")
@RestController
public class PilotCertificationController extends BaseController {

    @Autowired
    private PilotCertificationService certificationService;

    @ApiOperation(value = "能力类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = RoleInfoDTO.class)})
    @GetMapping("/abilityList")
    public ResultBody<PilotAbilityDTO> abilityList(HttpServletRequest request) {
        return certificationService.abilityList();
    }


    @ApiOperation(value = "小程序——申请——飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertPilot")
    public ResultBody insertPilot(HttpServletRequest request, @RequestBody @Validated(value = {Create.class}) PilotCertificationVO certificationVO) {
        return certificationService.insertPilot(certificationVO, this.getUserLoginInfoFromRedis(request));
    }


    @ApiOperation(value = "小程序——编辑——飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/updatePilot")
    public ResultBody updatePilot(HttpServletRequest request, @RequestBody @Validated(value = {Update.class}) PilotCertificationVO certificationVO) {
        return certificationService.updatePilot(certificationVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "小程序——列表————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/appListPilot")
    public ResultBody<PilotCertificationDTO> pilotList(HttpServletRequest request,
                                                       @Validated(value = {Page.class}) @ApiParam(value = "飞手查询", required = true) @RequestBody PilotCertificationQO param) {
        String token = request.getHeader("token");
        if (token!=null){
            Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
            param.setTokenUserId(userAccountId);
        }
        return ResultBody.success(certificationService.pilotList(param));
    }


    @ApiOperation(value = "小程序——详情————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @GetMapping("/detailPilot")
    public ResultBody<PilotCertificationDTO> detailPilot(HttpServletRequest request, @RequestParam(value = "id", required = true) Integer id) {
        return ResultBody.success(certificationService.detailPilot(id));
    }

    @ApiOperation(value = "小程序——用户详情————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @GetMapping("/userDetailPilot")
    public ResultBody<PilotCertificationDTO> userDetailPilot(HttpServletRequest request) {
        return ResultBody.success(certificationService.userDetailPilot(this.getUserLoginInfoFromRedis(request).getUserAccountId()));
    }


    @ApiOperation(value = "后台管理——列表————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/backListPilot")
    public ResultBody<PilotCertificationDTO> backListPilot(HttpServletRequest request,
                                                           @Validated(value = {Page.class}) @ApiParam(value = "飞手查询", required = true) @RequestBody PilotCertificationQO param) {
        return ResultBody.success(certificationService.backListPilot(param, this.getUserLoginInfoFromRedis(request)));
    }

    @ApiOperation(value = "后台管理——统计————飞手审核各个状态总数")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotAuditSumVO.class)})
    @GetMapping("/getPilotAuditSum")
    public ResultBody getPilotAuditSumVO() {
        return certificationService.getPilotAuditSum();
    }



    @ApiOperation(value = "后台管理——审批不通过原因————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @GetMapping("/backListReason")
    public ResultBody<PilotReasonDTO> backListReason() {
        return certificationService.backListReason();
    }


    @ApiOperation(value = "后台管理——详情————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @GetMapping("/backDetailPilot")
    public ResultBody<PilotCertificationDTO> backDetailPilot(HttpServletRequest request, @RequestParam(value = "id", required = true) Integer id) {
        return ResultBody.success(certificationService.detailPilot(id));
    }

    @ApiOperation(value = "后台管理——修改备注————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/updateRemark")
    public ResultBody updateRemark(HttpServletRequest request, @Validated(value = {Update.class}) @ApiParam(value = "修改备注", required = true) @RequestBody PilotRemarkQO param) {
        return certificationService.updateRemark(param, this.getUserLoginInfoFromRedis(request));
    }


    @ApiOperation(value = "后台管理——审批————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/updateAuditStatus")
    public ResultBody updateAuditStatus(HttpServletRequest request, @Validated(value = {Update.class}) @ApiParam(value = "修改审批状态", required = true) @RequestBody PilotAuditStatusQO param) {
        return certificationService.updateAuditStatus(param, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "后台管理——日志列表————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/backPilotLogList")
    public ResultBody<PilotCertificationLogDTO> backPilotLogList(HttpServletRequest request,
                                                                 @Validated(value = {Page.class}) @ApiParam(value = "飞手查询", required = true) @RequestBody PilotCertificationLogQO param) {
        return ResultBody.success(certificationService.backPilotLogList(param, this.getUserLoginInfoFromRedis(request)));
    }


    @ApiOperation(value = "后台内部调用——详情————飞手执照及能力认证")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @GetMapping("/interiorDetailPilot")
    public PilotCertificationInteriorDTO interiorDetailPilot(@RequestParam(value = "userAccountId", required = true) Integer userAccountId) {
        return certificationService.interiorDetailPilot(userAccountId);
    }

}
