package com.mmc.iuav.user.model.qo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.domain.Page;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;


/**
 * @author Admin
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserPartnerQO implements Serializable {

    private String userAddress;

    private String userName;

    private String phoneNumber;

    private Integer id;
    /**
     * 1同意 2拒绝
     */
    private Integer status;

    @ApiModelProperty(value = "页码", required = true, example = "1")
    @NotNull(message = "页码不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageNo;

    @ApiModelProperty(value = "每页显示数", required = true, example = "10")
    @NotNull(message = "每页显示数不能为空", groups = Page.class)
    @Min(value = 1, groups = Page.class)
    private Integer pageSize;

    public void buildCurrentPage() {
        this.pageNo = (pageNo - 1) * pageSize;
    }
}
