package com.mmc.iuav.user.controller.userpoints;

import com.mmc.iuav.group.Page;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.dto.dronepilot.PilotCertificationDTO;
import com.mmc.iuav.user.model.dto.userpoints.UserPointsDTO;
import com.mmc.iuav.user.model.dto.userpoints.UserPointsDetailsDTO;
import com.mmc.iuav.user.model.qo.userpoints.AppPointsDetailsQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointQO;
import com.mmc.iuav.user.model.qo.userpoints.UserPointsDetailsQO;
import com.mmc.iuav.user.model.vo.BuyPointsVO;
import com.mmc.iuav.user.model.vo.userpoints.ChangeUserPointVO;
import com.mmc.iuav.user.service.userpoints.UserPointsService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author small
 * @Date 2023/8/5 16:28
 * @Version 1.0
 */
@Api(tags = "积分")
@RequestMapping("/userPoint")
@RestController
public class UserPointsController extends BaseController {

    @Autowired
    private UserPointsService userPointsService;


    @ApiOperation(value = "后台管理——积分列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/userPointList")
    public ResultBody<UserPointsDTO> userPointList(HttpServletRequest request,
                                                   @Validated(value = {Page.class}) @ApiParam(value = "积分查询", required = true) @RequestBody UserPointQO param) {
        return ResultBody.success(userPointsService.userPointList(param));
    }

    @ApiOperation(value = "后台管理——积分详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/detailPoint")
    public ResultBody<UserPointsDetailsDTO> detailPoint(HttpServletRequest request,
                                                        @Validated(value = {Page.class}) @ApiParam(value = "积分查询", required = true) @RequestBody UserPointsDetailsQO param) {
        return ResultBody.success(userPointsService.detailPoint(param));
    }

    @ApiOperation(value = "小程序用户——积分详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = PilotCertificationDTO.class)})
    @PostMapping("/appDetailPoint")
    public ResultBody<UserPointsDetailsDTO> appDetailPoint(HttpServletRequest request, @Validated(value = {Page.class}) @ApiParam(value = "积分查询", required = true) @RequestBody AppPointsDetailsQO param) {
        return ResultBody.success(userPointsService.appDetailPoint(this.getUserLoginInfoFromRedis(request).getUserAccountId(), param));
    }

    @ApiOperation(value = "用户积分变更")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/change")
    public ResultBody change(@Validated(value = {Update.class}) @RequestBody ChangeUserPointVO changePoint) {
        return userPointsService.change(changePoint);
    }

    @ApiOperation(value = "积分变更类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/listChangeType")
    public ResultBody listChangeType() {
        return userPointsService.listChangeType();
    }


    @ApiOperation(value = "积分变动接口")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/changeUserPoints")
    public ResultBody changeUserPoints(HttpServletRequest request,@RequestParam("id") Integer id) {
        return userPointsService.changeUserPoints(this.getUserLoginInfoFromRedis(request).getUserAccountId(), id,0,null);
    }

    @ApiOperation(value = "远程调用——积分变动接口")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/feignChangeUserPoints")
    @ApiIgnore
    public ResultBody feignChangeUserPoints(HttpServletRequest request,@RequestParam("changePoint") int changePoint,String reason) {
        return userPointsService.changeUserPoints(this.getUserLoginInfoFromRedis(request).getUserAccountId(), null,changePoint,reason);
    }


    @ApiOperation(value = "用户购买积分(微信支付已成功)")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/weixinBuyPoints")
    public ResultBody weixinBuyPoints(@RequestBody BuyPointsVO buyPointsVO,HttpServletRequest request) {
        return userPointsService.weixinBuyPoints(buyPointsVO,this.getUserLoginInfoFromRedis(request).getUserAccountId(),this.getUserLoginInfoFromRedis(request).getToken());
    }

    @ApiOperation(value = "返回购买积分选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/selectAllBuyPointsType")
    public ResultBody selectAllBuyPointsType(){
        return userPointsService.selectAllBuyPointsType();
    }
    @ApiOperation(value = "后台管理——修改购买积分选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/updateBuyPointsType")
    public ResultBody updateBuyPointsType(@RequestBody BuyPointsVO buyPointsVO){
        return userPointsService.updateBuyPointsType(buyPointsVO);
    }
    @ApiOperation(value = "后台管理——新增购买积分选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertBuyPointsType")
    public ResultBody insertBuyPointsType(@RequestBody BuyPointsVO buyPointsVO){
        return userPointsService.insertBuyPointsType(buyPointsVO);
    }

    @ApiOperation(value = "根据类型ID返回购买积分选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/buyPointsTypeById")
    public Integer buyPointsTypeById(@ApiParam(value = "购买积分的类型id，唯一识别id", required = true)  Integer typeId){
        return userPointsService.buyPointsTypeById(typeId);
    }

}
