package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.CompanyAuthVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/5/17 14:22
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CompanyAuthDO implements Serializable {
    private static final long serialVersionUID = -9166003341814537635L;
    @ApiModelProperty(value = "id")
    private Integer id;
    @ApiModelProperty(value = "用户id")
    private Integer userAccountId;
    @ApiModelProperty(value = "企业名称")
    private String companyName;
    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;
    @ApiModelProperty(value = "营业执照")
    private String licenseImg;
    @ApiModelProperty(value = "企业认证状态，0未通过，1已通过")
    private Integer authStatus;

    public CompanyAuthDO(CompanyAuthVO companyAuthVO) {
        this.userAccountId = companyAuthVO.getUserAccountId();
        this.companyName = companyAuthVO.getCompanyName();
        this.creditCode = companyAuthVO.getCreditCode();
        this.licenseImg = companyAuthVO.getLicenseImg();
    }

    public CompanyAuthVO buildCompanyAuth() {
        return CompanyAuthVO.builder().id(this.id).companyName(this.companyName).userAccountId(this.userAccountId)
                .creditCode(this.creditCode).authStatus(this.authStatus).licenseImg(this.licenseImg).build();
    }
}
