package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Create;
import com.mmc.iuav.group.Update;
import com.mmc.iuav.group.UpdatePassword;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;
import com.mmc.iuav.user.service.BackUserAccountService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/25 11:22
 */
@Api(tags = "后台用户相关接口")
@RequestMapping("/back-user/")
@RestController
public class BackUserAccountController extends BaseController {

    @Autowired
    private BackUserAccountService backUserAccountService;

    @ApiOperation(value = "账号-新增")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("insertBAccount")
    public ResultBody insertBAccount(@Validated(value = {Create.class}) @RequestBody BUserAccountVO bUserAccountVO) {
        return backUserAccountService.insertBAccount(bUserAccountVO);
    }

    @ApiOperation(value = "账号-修改")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updateBAccount")
    public ResultBody updateBAccount(@Validated(value = {Update.class}) @RequestBody BUserAccountVO bUserAccountVO, HttpServletRequest request) {
        return backUserAccountService.updateBAccount(bUserAccountVO, this.getUserLoginInfoFromRedis(request));
    }

    @ApiOperation(value = "账号-禁用（原删除）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("removeBAccount")
    public ResultBody disableBAccount(@RequestParam Integer userAccountId, HttpServletRequest request) {
        return backUserAccountService.disableBAccount(userAccountId, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "账号-列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("listBAccountPage")
    public ResultBody<BackUserAccountVO> listBAccountPage(@ApiParam(value = "账号查询QO", required = true) @RequestBody BUserAccountQO bUserAccountQO) {
        return backUserAccountService.listBAccountPage(bUserAccountQO);
    }

    @ApiOperation(value = "账号-后台用户列表-内部调用", hidden = true)
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = List.class)})
    @PostMapping("feignListBAccountPage")
    public List<BackUserAccountVO> feignListBAccountPage(@ApiParam(value = "账号查询QO", required = true) @RequestBody BUserAccountQO bUserAccountQO) {
        return backUserAccountService.feignListBAccountPage(bUserAccountQO);
    }

    @ApiOperation(value = "账号管理-修改密码")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("updatePassword")
    public ResultBody updatePassword(@Validated(value = {UpdatePassword.class}) @RequestBody BUserAccountVO account) {
        return backUserAccountService.updatePassword(account);
    }

    @ApiOperation(value = "feign-验证用户密码")
    @ApiIgnore
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("feignAuthUserPwd")
    public ResultBody feignAuthUserPwd(@RequestParam(required = true) Integer id,
                                       @RequestParam(required = true) String authPwd) {
        return backUserAccountService.feignAuthUserPwd(id, authPwd);
    }

}
