package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 21:18
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserAccountVO implements Serializable {
    private static final long serialVersionUID = 7067111726018678883L;
    @ApiModelProperty(value = "用户id")
    @NotNull(message = "用户id不能为空", groups = {Update.class})
    private Integer id;
    @ApiModelProperty(value = "用户类型")
    private Integer accountType;
    @ApiModelProperty(value = "用户uid")
    private String uid;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "用户名称")
    private String userName;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "用户头像")
    private String userImg;
    @ApiModelProperty(value = "用户性别：0未知、1男、2女")
    private Integer userSex;
    @ApiModelProperty(value = "用户邮箱")
    @Email
    private String email;
    @ApiModelProperty(value = "用户来源，0自然流、1海报、2抖音、3公众号、4社群、5招投标、6官网")
    private Integer source;
    @ApiModelProperty(value = "用户可用状态：0禁用、1可用")
    private Integer accountStatus;
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty(value = "账号类型：0后台管理账号 ; 100云享飞-客户端;")
    private Integer portType;
    @ApiModelProperty(value = "注册时间")
    private Date createTime;
    @ApiModelProperty(value = "企业认证状态, 0未通过，1通过")
    private Integer companyAuthStatus;
    @ApiModelProperty(value = "企业名称")
    private String companyName;
    @ApiModelProperty(value = "是否删除")
    private Integer deleted;
    @ApiModelProperty(value = "推荐伙伴个数")
    private Integer inviteCount;
    @ApiModelProperty(value = "用户合作标签")
    private List<CooperationTagVO> cooperationTagVOS;
    @ApiModelProperty(value = "上级推荐人")
    private UserRcdVO userRcdVO;
}
