package com.mmc.iuav.user.service.wallet.impl;

import com.mmc.iuav.general.CodeUtil;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.dao.UserServiceDao;
import com.mmc.iuav.user.dao.wallet.PayWalletDao;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.entity.wallet.PayLogDO;
import com.mmc.iuav.user.entity.wallet.PayWalletDO;
import com.mmc.iuav.user.enums.PayMethodEnums;
import com.mmc.iuav.user.model.dto.wallet.PayWalletDTO;
import com.mmc.iuav.user.model.vo.wallet.FlyerWalletFlowVO;
import com.mmc.iuav.user.model.vo.wallet.PublisherWalletFlowVO;
import com.mmc.iuav.user.model.vo.wallet.TopUpOrderVO;
import com.mmc.iuav.user.model.vo.wallet.WalletFlowVO;
import com.mmc.iuav.user.service.wallet.PayWalletService;
import com.mmc.iuav.user.util.TDateUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author LW
 * @date 2023/8/18 11:36
 * 概要：
 */
@Service
@Slf4j
public class PayWalletServiceImpl implements PayWalletService {
    @Resource
    PayWalletDao payWalletDao;
    @Resource
    UserServiceDao userServiceDao;

    @Override
    public ResultBody getPayWalletInfo(Integer userAccountId) {
        PayWalletDO wallet = payWalletDao.getPayWalletByUser(userAccountId);
        if (wallet == null) {
            return null;
        }
        PayWalletDTO pd = wallet.buildPayWalletDTO();
        pd.mathTotal();
        return ResultBody.success(pd);
    }

    @Override
    public ResultBody initPayWallet(Integer userAccountId) {
        PayWalletDO wallet = new PayWalletDO();
        wallet.defaultValue();
        wallet.setUserAccountId(userAccountId);
        payWalletDao.insertPayWalletInfo(wallet);
        return ResultBody.success();
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public ResultBody feignWalletFlow(WalletFlowVO walletFlowVO) {
        // 获取发布者的信息
        PublisherWalletFlowVO publisherWalletFlowVO = walletFlowVO.getPublisherWalletFlowVO();
        // 获取接单者的信息
        FlyerWalletFlowVO flyerWalletFlowVO = walletFlowVO.getFlyerWalletFlowVO();
        // 发布者的钱包信息
        PayWalletDO publishWallet = new PayWalletDO();
        // 接单者的钱包信息
        PayWalletDO flyerWallet = new PayWalletDO();
        // 获取用户钱包信息
        if (publisherWalletFlowVO != null) {
            publishWallet = payWalletDao.getPayWalletByUser(publisherWalletFlowVO.getUserAccountId());
        }
        if (flyerWalletFlowVO != null) {
            flyerWallet = payWalletDao.getPayWalletByUser(flyerWalletFlowVO.getUserAccountId());
        }
        // 判断状态进行资金的扣减等于100时 发布订单
        if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.PUBLISH_ORDER.getCode())) {
            PayWalletDO publishUpdatePayWallet = new PayWalletDO();
            publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishUpdatePayWallet.setPid(publishWallet.getPid());
            publishUpdatePayWallet.setCashAmt(publishWallet.getCashAmt().add(publisherWalletFlowVO.getCashAmount())
                    .add(publisherWalletFlowVO.getTopYxjAmount()).add(publisherWalletFlowVO.getUrgentYxjAmount()));
            publishUpdatePayWallet.setCashFreeze(publishWallet.getCashFreeze().subtract(publisherWalletFlowVO.getCashAmount())
                    .subtract(publisherWalletFlowVO.getTopYxjAmount()).subtract(publisherWalletFlowVO.getUrgentYxjAmount()));
            publishUpdatePayWallet.setSalaryAmt(publishWallet.getSalaryAmt().add(publisherWalletFlowVO.getSalaryAmount())
                    .add(publisherWalletFlowVO.getTopSalaryAmount()).add(publisherWalletFlowVO.getUrgentSalaryAmount()));
            publishUpdatePayWallet.setSalaryFreeze(publishWallet.getSalaryFreeze().subtract(publisherWalletFlowVO.getSalaryAmount())
                    .subtract(publisherWalletFlowVO.getTopSalaryAmount()).subtract(publisherWalletFlowVO.getUrgentSalaryAmount()));
            int i = payWalletDao.updatePayWallet(publishUpdatePayWallet);
            if (i > 0) {
                PayLogDO payLogDO = buildPayLogDO(publisherWalletFlowVO, null);
                payLogDO.setCashAmtPaid(publisherWalletFlowVO.getCashAmount().add(publisherWalletFlowVO.getTopYxjAmount()).add(publisherWalletFlowVO.getUrgentYxjAmount()));
                payLogDO.setSalaryAmtPaid(publisherWalletFlowVO.getSalaryAmount().add(publisherWalletFlowVO.getTopSalaryAmount()).add(publisherWalletFlowVO.getUrgentSalaryAmount()));
                // 插入流水记录表
                payWalletDao.insertPayLogDO(payLogDO);
                return ResultBody.success();
            } else {
                log.error("发布订单时，用户钱包更新失败，用户id是:{}，传入参数是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
                return ResultBody.error("钱包操作错误");
            }
        } else if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.CANCEL_ORDER_TAKING.getCode())) {
            // 等于200时 发布方取消订单，无飞手接单
            PayWalletDO publishUpdatePayWallet = new PayWalletDO();
            publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishUpdatePayWallet.setPid(publishWallet.getPid());
            publishUpdatePayWallet.setCashAmt(publishWallet.getCashAmt().add(publisherWalletFlowVO.getCashAmount()));
            publishUpdatePayWallet.setCashFreeze(publishWallet.getCashFreeze().add(publisherWalletFlowVO.getTopYxjAmount()).add(publisherWalletFlowVO.getUrgentYxjAmount()).subtract(publisherWalletFlowVO.getCashAmount()));
            publishUpdatePayWallet.setSalaryAmt(publishWallet.getSalaryAmt().add(publisherWalletFlowVO.getSalaryAmount()));
            publishUpdatePayWallet.setSalaryFreeze(publishWallet.getSalaryFreeze().add(publisherWalletFlowVO.getTopSalaryAmount()).add(publisherWalletFlowVO.getUrgentSalaryAmount()).subtract(publisherWalletFlowVO.getSalaryAmount()));
            int i = payWalletDao.updatePayWallet(publishUpdatePayWallet);
            if (i > 0) {
                PayLogDO payLogDO = buildPayLogDO(publisherWalletFlowVO, null);
                // 插入流水记录表
                payWalletDao.insertPayLogDO(payLogDO);
                return ResultBody.success();
            } else {
                log.error("发布方取消订单，无飞手接单时，用户id是:{}，传入参数是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
                return ResultBody.error("钱包操作错误");
            }
        } else if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.RECEIVED_ORDER_CANCEL.getCode())) {
            // 等于300时 发布方取消订单，有飞手接单
            if (publisherWalletFlowVO.getYxjCashPledge() == null) {
                publisherWalletFlowVO.setYxjCashPledge(BigDecimal.ZERO);
            }
            if (publisherWalletFlowVO.getSalaryCashPledge() == null) {
                publisherWalletFlowVO.setSalaryCashPledge(BigDecimal.ZERO);
            }
            PayWalletDO publishUpdatePayWallet = new PayWalletDO();
            publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishUpdatePayWallet.setPid(publishWallet.getPid());
            publishUpdatePayWallet.setCashAmt(publishWallet.getCashAmt().add(publisherWalletFlowVO.getCashAmount()));
            publishUpdatePayWallet.setCashFreeze(publishWallet.getCashFreeze().subtract(publisherWalletFlowVO.getCashAmount()).add(publisherWalletFlowVO.getYxjCashPledge()));
            publishUpdatePayWallet.setSalaryAmt(publishWallet.getSalaryAmt().add(publisherWalletFlowVO.getSalaryAmount()));
            publishUpdatePayWallet.setSalaryFreeze(publishWallet.getSalaryFreeze().subtract(publisherWalletFlowVO.getSalaryAmount()).add(publisherWalletFlowVO.getSalaryCashPledge()));
            // 更新发布者钱包数据
            int publishUpdateCount = payWalletDao.updatePayWallet(publishUpdatePayWallet);
            if (publishUpdateCount <= 0) {
                log.error("发布方取消订单，有飞手接单时，发单方用户钱包更新失败，更新参数是：{},发单方用户id是:{}，传入参数是：{}", publishUpdatePayWallet, publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
                return ResultBody.error("钱包操作错误");
            }
            PayLogDO publishPayLogDO = buildPayLogDO(publisherWalletFlowVO, null);
            // 插入发布者流水记录表
            payWalletDao.insertPayLogDO(publishPayLogDO);
            // 飞手钱包更新信息
            PayWalletDO flyerUpdatePayWallet = new PayWalletDO();
            // 断言此处必定不为空
            assert flyerWalletFlowVO != null;
            flyerUpdatePayWallet.setUserAccountId(flyerWalletFlowVO.getUserAccountId());
            flyerUpdatePayWallet.setPid(flyerWallet.getPid());
            flyerUpdatePayWallet.setSalaryAmt(flyerWallet.getSalaryAmt().add(publisherWalletFlowVO.getPercentagePenaltyOfOrder()));
            int flyerUpdateCount = payWalletDao.updatePayWallet(flyerUpdatePayWallet);
            if (flyerUpdateCount > 0) {
                PayLogDO flyerPayLogDO = buildPayLogDO(publisherWalletFlowVO, flyerWalletFlowVO);
                flyerPayLogDO.setCashAmtPaid(publisherWalletFlowVO.getPercentagePenaltyOfOrder());
                flyerPayLogDO.setOperateUser(publisherWalletFlowVO.getOperateUserAccountId());
                // 插入流水记录表
                payWalletDao.insertPayLogDO(flyerPayLogDO);
                return ResultBody.success();
            } else {
                log.error("发布方取消订单，有飞手接单时，飞手用户钱包更新失败,飞手用户id是:{}，接单方传入参数是：{}，发单方违约金是：{}", flyerWalletFlowVO.getUserAccountId(), flyerWalletFlowVO, publisherWalletFlowVO.getPercentagePenaltyOfOrder());
            }
        } else if (flyerWalletFlowVO != null && flyerWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.FLYING_ORDER_TAKING.getCode())) {
            // 状态为400时 表示飞手接单
            // 飞手钱包更新信息
            int flyerUpdateCount = buildFlyerWallet(flyerWalletFlowVO, flyerWallet);
            if (flyerUpdateCount > 0) {
                PayLogDO flyerPayLogDO = buildPayLogDO(null, flyerWalletFlowVO);
                // 插入流水记录表
                payWalletDao.insertPayLogDO(flyerPayLogDO);
                return ResultBody.success();
            } else {
                log.error("飞手抢单时，飞手用户钱包更新失败,飞手用户id是:{}，传入参数是：{}", flyerWalletFlowVO.getUserAccountId(), flyerWalletFlowVO);
            }
        } else if (flyerWalletFlowVO != null && flyerWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.CUSTOMER_SERVICE_CANCEL_ORDER.getCode())) {
            // 状态为500时 客服判定飞手无责取消订单
            // 飞手钱包更新信息
            int flyerUpdateCount = buildFlyerWallet(flyerWalletFlowVO, flyerWallet);
            if (flyerUpdateCount > 0) {
                PayLogDO flyerPayLogDO = buildPayLogDO(null, flyerWalletFlowVO);
                // 插入流水记录表
                payWalletDao.insertPayLogDO(flyerPayLogDO);
                return ResultBody.success();
            } else {
                log.error("客服判定飞手无责取消订单时，飞手用户钱包更新失败,飞手用户id是:{}，传入参数是：{}", flyerWalletFlowVO.getUserAccountId(), flyerWalletFlowVO);
            }
        } else if (flyerWalletFlowVO != null && flyerWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.FLYER_CANCEL_ORDER.getCode())) {
            // 状态为600时 飞手有责取消订单
            // 飞手钱包更新信息
            PayWalletDO flyerUpdatePayWallet = new PayWalletDO();
            flyerUpdatePayWallet.setUserAccountId(flyerWalletFlowVO.getUserAccountId());
            flyerUpdatePayWallet.setPid(flyerWallet.getPid());
            flyerUpdatePayWallet.setCashFreeze(flyerWallet.getCashFreeze().add(flyerWalletFlowVO.getYxjCashPledge()));
            flyerUpdatePayWallet.setSalaryFreeze(flyerWallet.getSalaryFreeze().add(flyerWalletFlowVO.getSalaryCashPledge()));
            int flyerUpdateCount = payWalletDao.updatePayWallet(flyerUpdatePayWallet);
            if (flyerUpdateCount <= 0) {
                log.error("飞手有责取消订单，飞手用户钱包更新失败,飞手用户id是:{}，接单方传入参数是：{}", flyerWalletFlowVO.getUserAccountId(), flyerWalletFlowVO);
                return ResultBody.error("钱包操作错误");
            }
//            PayLogDO flyerPayLogDO = buildPayLogDO(null, flyerWalletFlowVO);
//            flyerPayLogDO.setCashAmtPaid(flyerWalletFlowVO.getYxjCashPledge());
//            flyerPayLogDO.setSalaryAmtPaid(flyerWalletFlowVO.getSalaryAmount());
//            // 插入接单者流水记录表
//            payWalletDao.insertPayLogDO(flyerPayLogDO);
            // 飞手钱包更新信息
            PayWalletDO publishUpdatePayWallet = new PayWalletDO();
            // 断言此处必定不为空
            assert publisherWalletFlowVO != null;
            publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishUpdatePayWallet.setPid(publishWallet.getPid());
            publishUpdatePayWallet.setSalaryAmt(publishWallet.getSalaryAmt().add(flyerWalletFlowVO.getPercentagePenaltyOfOrder()));
            int publishUpdateCount = payWalletDao.updatePayWallet(publishUpdatePayWallet);
            if (publishUpdateCount > 0) {
                PayLogDO publishPayLogDO = buildPayLogDO(publisherWalletFlowVO, null);
                publishPayLogDO.setCashAmtPaid(flyerWalletFlowVO.getPercentagePenaltyOfOrder());
                publishPayLogDO.setOperateUser(flyerWalletFlowVO.getOperateUserAccountId());
                // 插入流水记录表
                payWalletDao.insertPayLogDO(publishPayLogDO);
                return ResultBody.success();
            } else {
                log.error("飞手有责取消订单,发布者用户钱包更新失败,发布者用户id是:{}，发布方传入参数是：{}，接单方方违约金是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO, flyerWalletFlowVO.getPercentagePenaltyOfOrder());
            }
        } else if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.NORMAL_SETTLEMENT.getCode())) {
            // 状态为700时 正常订单结算
            // 解冻发布方订单的钱包金额
            PayWalletDO publishPayWalletDO = new PayWalletDO();
            publishPayWalletDO.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishPayWalletDO.setPid(publishWallet.getPid());
            publishPayWalletDO.setCashFreeze(publishWallet.getCashFreeze().subtract(publisherWalletFlowVO.getCashAmount())
                    .add(publisherWalletFlowVO.getUrgentYxjAmount()).add(publisherWalletFlowVO.getTopYxjAmount()));
            publishPayWalletDO.setSalaryFreeze(publishWallet.getSalaryFreeze().subtract(publisherWalletFlowVO.getSalaryAmount())
                    .add(publisherWalletFlowVO.getTopSalaryAmount()).add(publisherWalletFlowVO.getUrgentSalaryAmount()));
            int publishUpdateCount = payWalletDao.updatePayWallet(publishPayWalletDO);
            if (publishUpdateCount <= 0) {
                log.error("正常结算时，发布者用户钱包更新失败，发布者id是：{}，发布者传参是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
            }
            // 增加接单方钱包金额
            assert flyerWalletFlowVO != null;
            int flyerUpdateCount = addFlyerSalary(publisherWalletFlowVO, flyerWalletFlowVO, flyerWallet);
            if (flyerUpdateCount > 0) {
                // 记录流水记录
                PayLogDO flyerPayLogDO = buildPayLogDO(null, flyerWalletFlowVO);
                flyerPayLogDO.setSalaryAmtPaid(publisherWalletFlowVO.getFlyerSalaryAmount());
                flyerPayLogDO.setOperateUser(publisherWalletFlowVO.getUserAccountId());
                // 插入接单者流水记录表
                payWalletDao.insertPayLogDO(flyerPayLogDO);
                return ResultBody.success();
            } else {
                log.error("正常结算时，接单方用户钱包更新失败，接单者id是：{}，发布者传参是：{}", flyerWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
            }
        } else if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.MODIFY_THE_ORDER.getCode())) {
            // 状态为800时 发布方修改金额大于原来订单佣金
            // 发布方还需补金额
            if (releaseOrCancelOrderWallet(publisherWalletFlowVO, publishWallet)) {
                PayLogDO payLogDO = buildPayLogDO(publisherWalletFlowVO, null);
                // 插入流水记录表
                payWalletDao.insertPayLogDO(payLogDO);
                return ResultBody.success();
            } else {
                log.error("发布方修改金额大于原来订单佣金时，用户钱包更新失败，用户id是:{}，传入参数是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
                return ResultBody.error("钱包操作错误");
            }
        } else if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.FLYING_HAND_NOT_CONFIRMED_GT.getCode())) {
            // 状态为900时 飞手未确认修改金额大于原订单状态时订单结算
            // 退回发布方后面补的金额
            PayWalletDO publishUpdatePayWallet = new PayWalletDO();
            publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishUpdatePayWallet.setPid(publishWallet.getPid());
            publishUpdatePayWallet.setSalaryAmt(publishWallet.getSalaryAmt().add(publisherWalletFlowVO.getRefundSalaryAmount()));
            publishUpdatePayWallet.setSalaryFreeze(publishWallet.getSalaryFreeze().subtract(publisherWalletFlowVO.getRefundSalaryAmount()));
            publishUpdatePayWallet.setCashAmt(publishWallet.getCashAmt().add(publisherWalletFlowVO.getRefundCashAmount()));
            publishUpdatePayWallet.setCashFreeze(publishWallet.getCashFreeze().subtract(publisherWalletFlowVO.getRefundCashAmount()));
            int publishUpdateCount = payWalletDao.updatePayWallet(publishUpdatePayWallet);
            if (publishUpdateCount <= 0) {
                log.error("飞手未确认修改金额大于原订单状态时，发布者用户钱包更新失败，发布者id是：{}，发布者参数是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
            }
            // 记录发单方退回多余金额记录
            refund(publisherWalletFlowVO);
            // 增加接单方钱包金额
            assert flyerWalletFlowVO != null;
            int flyerUpdateCount = addFlyerSalary(publisherWalletFlowVO, flyerWalletFlowVO, flyerWallet);
            if (flyerUpdateCount > 0) {
                // 记录流水记录
                PayLogDO flyerPayLogDO = buildPayLogDO(null, flyerWalletFlowVO);
                flyerPayLogDO.setSalaryAmtPaid(publisherWalletFlowVO.getFlyerSalaryAmount());
                flyerPayLogDO.setOperateUser(publisherWalletFlowVO.getUserAccountId());
                // 插入接单者流水记录表
                payWalletDao.insertPayLogDO(flyerPayLogDO);
                return ResultBody.success();
            } else {
                log.error("飞手未确认修改金额大于原订单状态时，接单方用户钱包更新失败，接单者id是：{}，发布者传参是：{}", flyerWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
            }
        } else if (publisherWalletFlowVO != null && publisherWalletFlowVO.getModeOfPayment().equals(PayMethodEnums.FLYING_HAND_CONFIRM_LT.getCode())) {
            // 状态为1000时 飞手确认修改金额小于原订单状态
            // 退回发布方多余原订单金额,解冻钱包金额
            PayWalletDO publishUpdatePayWallet = new PayWalletDO();
            publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            publishUpdatePayWallet.setPid(publishWallet.getPid());
            publishUpdatePayWallet.setCashAmt(publishWallet.getCashAmt().add(publisherWalletFlowVO.getRefundCashAmount()));
            publishUpdatePayWallet.setCashFreeze(publishWallet.getCashFreeze().subtract(publisherWalletFlowVO.getRefundCashAmount())
                    .subtract(publisherWalletFlowVO.getCashAmount()).add(publisherWalletFlowVO.getUrgentYxjAmount()).add(publisherWalletFlowVO.getTopYxjAmount()));
            publishUpdatePayWallet.setSalaryAmt(publishWallet.getSalaryAmt().add(publisherWalletFlowVO.getRefundSalaryAmount()));
            publishUpdatePayWallet.setSalaryFreeze(publishWallet.getSalaryFreeze().subtract(publisherWalletFlowVO.getRefundSalaryAmount())
                    .subtract(publisherWalletFlowVO.getSalaryAmount()).add(publisherWalletFlowVO.getUrgentSalaryAmount()).add(publisherWalletFlowVO.getTopYxjAmount()));
            int publishUpdateCount = payWalletDao.updatePayWallet(publishUpdatePayWallet);
            if (publishUpdateCount <= 0) {
                log.error("飞手确认修改金额小于原订单状态，发布者用户钱包更新失败，发布者id是：{}，发布者参数是：{}", publisherWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
            }
            // 记录多余退款记录
            refund(publisherWalletFlowVO);
            // 增加接单方钱包金额
            assert flyerWalletFlowVO != null;
            int flyerUpdateCount = addFlyerSalary(publisherWalletFlowVO, flyerWalletFlowVO, flyerWallet);
            if (flyerUpdateCount > 0) {
                // 记录流水记录
                PayLogDO flyerPayLogDO = buildPayLogDO(null, flyerWalletFlowVO);
                flyerPayLogDO.setSalaryAmtPaid(publisherWalletFlowVO.getFlyerSalaryAmount());
                flyerPayLogDO.setOperateUser(publisherWalletFlowVO.getUserAccountId());
                // 插入接单者流水记录表
                payWalletDao.insertPayLogDO(flyerPayLogDO);
                return ResultBody.success();
            } else {
                log.error("飞手确认修改金额小于原订单状态，接单方用户钱包更新失败，接单者id是：{}，发布者传参是：{}", flyerWalletFlowVO.getUserAccountId(), publisherWalletFlowVO);
            }
        }
        return ResultBody.error("钱包操作错误");
    }

    private int buildFlyerWallet(FlyerWalletFlowVO flyerWalletFlowVO, PayWalletDO flyerWallet) {
        PayWalletDO flyerUpdatePayWallet = new PayWalletDO();
        flyerUpdatePayWallet.setUserAccountId(flyerWalletFlowVO.getUserAccountId());
        flyerUpdatePayWallet.setPid(flyerWallet.getPid());
        flyerUpdatePayWallet.setCashAmt(flyerWallet.getCashAmt().add(flyerWalletFlowVO.getCashAmount()));
        flyerUpdatePayWallet.setCashFreeze(flyerWallet.getCashFreeze().subtract(flyerWalletFlowVO.getCashAmount()));
        flyerUpdatePayWallet.setSalaryAmt(flyerWallet.getSalaryAmt().add(flyerWalletFlowVO.getSalaryAmount()));
        flyerUpdatePayWallet.setSalaryFreeze(flyerWallet.getSalaryFreeze().subtract(flyerWalletFlowVO.getSalaryAmount()));
        int flyerUpdateCount = payWalletDao.updatePayWallet(flyerUpdatePayWallet);
        return flyerUpdateCount;
    }

    private void refund(PublisherWalletFlowVO publisherWalletFlowVO) {
        if (publisherWalletFlowVO.getRefundCashAmount().compareTo(BigDecimal.ZERO) != 0 || publisherWalletFlowVO.getRefundSalaryAmount().compareTo(BigDecimal.ZERO) != 0) {
            PayLogDO publishPayLogDO = buildPayLogDO(publisherWalletFlowVO, null);
            publishPayLogDO.setCashAmtPaid(publisherWalletFlowVO.getRefundCashAmount());
            publishPayLogDO.setSalaryAmtPaid(publisherWalletFlowVO.getRefundSalaryAmount());
            payWalletDao.insertPayLogDO(publishPayLogDO);
        }
    }

    private int addFlyerSalary(PublisherWalletFlowVO publisherWalletFlowVO, FlyerWalletFlowVO flyerWalletFlowVO, PayWalletDO flyerWallet) {
        assert flyerWalletFlowVO != null;
        PayWalletDO flyerPayWalletDO = new PayWalletDO();
        flyerPayWalletDO.setUserAccountId(flyerWalletFlowVO.getUserAccountId());
        flyerPayWalletDO.setPid(flyerWallet.getPid());
        flyerPayWalletDO.setSalaryAmt(flyerWallet.getSalaryAmt().add(publisherWalletFlowVO.getFlyerSalaryAmount()));
        int flyerUpdateCount = payWalletDao.updatePayWallet(flyerPayWalletDO);
        return flyerUpdateCount;
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean releaseOrCancelOrderWallet(PublisherWalletFlowVO publisherWalletFlowVO, PayWalletDO wallet) {
        PayWalletDO publishUpdatePayWallet = new PayWalletDO();
        if (publisherWalletFlowVO.getCashAmount() == null) {
            publisherWalletFlowVO.setCashAmount(BigDecimal.ZERO);
        }
        if (publisherWalletFlowVO.getSalaryAmount() == null) {
            publisherWalletFlowVO.setSalaryAmount(BigDecimal.ZERO);
        }
        publishUpdatePayWallet.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
        publishUpdatePayWallet.setPid(wallet.getPid());
        publishUpdatePayWallet.setCashAmt(wallet.getCashAmt().add(publisherWalletFlowVO.getCashAmount()));
        publishUpdatePayWallet.setCashFreeze(wallet.getCashFreeze().subtract(publisherWalletFlowVO.getCashAmount()));
        publishUpdatePayWallet.setSalaryAmt(wallet.getSalaryAmt().add(publisherWalletFlowVO.getSalaryAmount()));
        publishUpdatePayWallet.setSalaryFreeze(wallet.getSalaryFreeze().subtract(publisherWalletFlowVO.getSalaryAmount()));
        int i = payWalletDao.updatePayWallet(publishUpdatePayWallet);
        if (i > 0) {
            return true;
        }
        return false;
    }

    public PayLogDO buildPayLogDO(PublisherWalletFlowVO publisherWalletFlowVO, FlyerWalletFlowVO flyerWalletFlowVO) {
        // 记录资金流水记录
        PayLogDO payLogWalletDO = new PayLogDO();
        // 获取用户钱包信息
        if (publisherWalletFlowVO != null) {
            if (publisherWalletFlowVO.getCashAmount() == null) {
                publisherWalletFlowVO.setCashAmount(BigDecimal.ZERO);
            }
            if (publisherWalletFlowVO.getSalaryAmount() == null) {
                publisherWalletFlowVO.setSalaryAmount(BigDecimal.ZERO);
            }
            // 生成支付流水号(规则"T" + 时间戳 + 用户id + 随机数4位)
            String publishPayNo = "T" + TDateUtil.getDateStr(new Date(), TDateUtil.TYPE) + publisherWalletFlowVO.getUserAccountId() + CodeUtil.getRandomNum(4);
            payLogWalletDO.setPayMethod(publisherWalletFlowVO.getModeOfPayment());
            payLogWalletDO.setPayNo(publishPayNo);
            payLogWalletDO.setUserAccountId(publisherWalletFlowVO.getUserAccountId());
            payLogWalletDO.setCashAmtPaid(publisherWalletFlowVO.getCashAmount());
            payLogWalletDO.setSalaryAmtPaid(publisherWalletFlowVO.getSalaryAmount());
            payLogWalletDO.setPayTime(publisherWalletFlowVO.getTimeOfPayment());
            payLogWalletDO.setOperateUser(publisherWalletFlowVO.getOperateUserAccountId());
            return payLogWalletDO;
        }
        if (flyerWalletFlowVO != null) {
            if (flyerWalletFlowVO.getCashAmount() == null) {
                flyerWalletFlowVO.setCashAmount(BigDecimal.ZERO);
            }
            if (flyerWalletFlowVO.getSalaryAmount() == null) {
                flyerWalletFlowVO.setSalaryAmount(BigDecimal.ZERO);
            }
            // 生成支付流水号(规则"T" + 时间戳 + 用户id + 随机数4位)
            String flyerPayNo = "T" + TDateUtil.getDateStr(new Date(), TDateUtil.TYPE) + flyerWalletFlowVO.getUserAccountId() + CodeUtil.getRandomNum(4);
            payLogWalletDO.setPayMethod(flyerWalletFlowVO.getModeOfPayment());
            payLogWalletDO.setPayNo(flyerPayNo);
            payLogWalletDO.setUserAccountId(flyerWalletFlowVO.getUserAccountId());
            payLogWalletDO.setCashAmtPaid(flyerWalletFlowVO.getCashAmount());
            payLogWalletDO.setSalaryAmtPaid(flyerWalletFlowVO.getSalaryAmount());
            payLogWalletDO.setPayTime(flyerWalletFlowVO.getTimeOfPayment());
            payLogWalletDO.setOperateUser(flyerWalletFlowVO.getOperateUserAccountId());
            return payLogWalletDO;
        }
        return null;
    }

    @Override
    public ResultBody feignTopUpCash(TopUpOrderVO topUpOrderVO) {
        // 获取用户openid查询到用户信息
        UserAccountDO userAccountDO = userServiceDao.getUserAccountInfoByOpenId(topUpOrderVO.getOpenid());
        // 根据金额转成元
        BigDecimal topUpAmount = BigDecimal.valueOf(topUpOrderVO.getAmount()).divide(new BigDecimal(100), 2, BigDecimal.ROUND_HALF_UP);
        // 根据用户id获取钱包金额信息
        PayWalletDO wallet = payWalletDao.getPayWalletByUser(userAccountDO.getId());
        // 修改云享金信息
        PayWalletDO payWalletDO = new PayWalletDO();
        payWalletDO.setCashAmt(wallet.getCashAmt().add(topUpAmount));
        payWalletDO.setPid(wallet.getPid());
        payWalletDO.setUserAccountId(userAccountDO.getId());
        int i = payWalletDao.updatePayWallet(payWalletDO);
        if (i > 0) {
            // 记录钱包流水
            PayLogDO payLogDO = new PayLogDO();
            payLogDO.setUserAccountId(userAccountDO.getId());
            payLogDO.setPayNo(topUpOrderVO.getOrderNo());
            payLogDO.setPayMethod(PayMethodEnums.USER_TOP_UP.getCode());
            payLogDO.setCashAmtPaid(topUpAmount);
            payLogDO.setOperateUser(userAccountDO.getId());
            payWalletDao.insertPayLogDO(payLogDO);
            return ResultBody.success();
        } else {
            return ResultBody.error("充值时钱包操作错误！");
        }
    }

    @Override
    public ResultBody customerBillingDetail(Integer userAccountId) {
        
        return null;
    }
}
