package com.mmc.iuav.user.entity.wallet;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 现金流水表(PayLogDO)实体类
 *
 * @author makejava
 * @since 2023-08-18 16:18:01
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PayLogDO implements Serializable {
    private static final long serialVersionUID = 752682324297846133L;

    private Integer id;
    /**
     * 支付人的userId
     */
    private Integer userAccountId;
    /**
     * 订单编号
     */
    private Integer orderNo;
    /**
     * 支付流水号(T202109031615XXXX)XXXX随机数
     */
    private String payNo;
    /**
     * 0手动变更(大于0充值or小于0扣除) 50订单取消 100订单扣除 150订单冻结  200订单完成  250充值 300 提现扣除
     */
    private Integer payMethod;
    /**
     * 云享金变动金额(正数充值，负数扣除)
     */
    private BigDecimal cashAmtPaid;
    /**
     * 佣金变动金额(正数入账，负数扣除)
     */
    private BigDecimal salaryAmtPaid;
    /**
     * 支付时间
     */
    private Date payTime;
    /**
     * 备注
     */
    private String remark;
    /**
     * 操作用户id
     */
    private Integer operateUser;

    private Date createTime;

    private Date updateTime;
}

