package com.mmc.iuav.user.dao.dronepilot;

import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.entity.dronepilot.PilotAbilityDO;
import com.mmc.iuav.user.entity.dronepilot.PilotCertificationDO;
import com.mmc.iuav.user.entity.dronepilot.PilotCertificationLogDO;
import com.mmc.iuav.user.entity.dronepilot.PilotReasonDO;
import com.mmc.iuav.user.model.dto.dronepilot.FlyingTeam;
import com.mmc.iuav.user.model.qo.dronepilot.*;
import com.mmc.iuav.user.model.vo.dronepilot.PilotAbilityVO;
import org.apache.ibatis.annotations.Mapper;

import java.util.List;

/**
 * @Author small
 * @Date 2023/7/28 9:36
 * @Version 1.0
 */
@Mapper
public interface PilotCertificationDao {
    List<PilotAbilityDO> abilityList();

    Integer selectRealNameAuth(Integer userAccountId);

    void insertPilot(PilotCertificationDO pilotCertificationDO);

    void insertAbility(List<PilotAbilityVO> list);

    void insertPilotLog(PilotCertificationLogDO pilotCertificationLog);

    Integer selectPilotCertification(Integer userAccountId);

    void deleteAbility(Integer id);

    void updatePilot(PilotCertificationDO pilotCertificationDO);

    Integer selectPilotCount(Integer id, Integer userAccountId);

    List<PilotCertificationDO> pilotList(PilotCertificationQO param);


    /**
     * 查询这个用户是否绑定飞手团队
     * @param userId 飞手id
     * @return int 1 说明绑定了 0 表示没有绑定
     */
    int selectCompanyByUserId(Integer userId);


    /**
     * 根据飞手id查询飞手团队名称
     * @param userId 飞手id
     * @return {@link String}
     */
    FlyingTeam selectCompanyNameByFlyingUserId(Integer userId);
    Integer getPilotAuditSum(Integer status);

    List<PilotAbilityVO> selectAbilityList(Integer pilotCertificationId);

    PilotCertificationDO detailPilot(Integer id);

    PilotCertificationDO userDetailPilot(Integer userAccountId);

    PilotCertificationDO interiorDetailPilot(Integer userAccountId);

    void updateRemark(PilotRemarkQO param);

    void updateAuditStatus(PilotAuditStatusQO param);

    UserAccountDO selectUserAccountId(PilotAuditStatusQO param);

    List<PilotCertificationLogDO> backPilotLogList(PilotCertificationLogQO param);

    List<PilotReasonDO> backListReason();

    PilotReasonDO selectPilotReason(String reasonId);

    int selectFirstApprove(Integer id);

    int getDronePilotCount();

    /**
     * 后台管理选择飞手加入自己的飞手团队
     * @param pilotId 飞手的user_id
     * @param backId 飞手团队后台账号的id
     */
    void insertPilotJoinTeam(Integer pilotId,Integer backId);

    /**
     * 在后台根据自己的后台id查找飞手团队中的成员
     * @param param 条件
     * @return {@link List}<{@link PilotCertificationDO}>
     */
    List<PilotCertificationDO> selectPilotListByTeam(PilotTeamQO param);


    /**
     * 根据飞手电话查询飞手是否加入飞手团队
     * @param phoneNumber 飞手电话
     * @return int 查到就是1已经有团队了 没查到0
     */
    int selectPilotTeamByPhone(String phoneNumber);


    /**
     * 按照电话号码查找通过审核的飞手
     * @param phoneNumber 飞手电话
     * @return {@link PilotCertificationDO}
     */
    PilotCertificationDO selectPilotByPhone(String phoneNumber);


    /**
     * 修改状态是否加入飞手团队
     * @param userId 飞手的id
     * @param pilotStatus 1 是同意加入 2 拒绝加入
     * @return int
     */
    int updatePilotStatus(Integer userId,Integer pilotStatus);


    /**
     * 通过飞手id去获取飞手所在飞手团队的团队信息
     * @param pilotId 飞手id
     * @param pilotStatus 查询不同状态 0飞手未操作 1飞手同意加入 2 飞手拒绝加入
     * @return {@link CompanyInfoDO}
     */
    CompanyInfoDO selectCompanyInfoByPilotId(Integer pilotId,Integer pilotStatus);


    /**
     * 根据飞手的id删除飞手绑定的飞手团队
     * @param pilotId 飞手的user_id
     */
    void deletePilotFromTeam(Integer pilotId);
}
