package com.mmc.iuav.user.entity.userpoints;

import com.mmc.iuav.user.model.dto.userpoints.UserPointsDTO;
import com.mmc.iuav.user.model.vo.userpoints.UserPointsVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * @Author small
 * @Date 2023/8/5 13:14
 * @Version 1.0
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserPointsDO {


    @ApiModelProperty(value = "id不能为空", example = "1")
    private Integer id;

    @ApiModelProperty(value = "用户id", example = "1")
    private Integer userAccountId;

    @ApiModelProperty(value = "积分总额", example = "10")
    private Integer totalPoints;

    @ApiModelProperty(value = "创建时间", example = "2023-08-05 16:25:02")
    private Date createTime;

    @ApiModelProperty(value = "更新时间", example = "2023-08-05 16:25:02")
    private Date updateTime;

    @ApiModelProperty(value = "微信昵称", example = "张三")
    private String nickName;

    @ApiModelProperty(value = "手机号", example = "189231321")
    private String phoneNum;

    public UserPointsDO(UserPointsVO userPointsVO) {
        this.id = userPointsVO.getId();
        this.userAccountId = userPointsVO.getUserAccountId();
        this.totalPoints = userPointsVO.getTotalPoints();
    }


    public UserPointsDTO buildUserPointsDTO() {
        return UserPointsDTO.builder()
                .id(this.id)
                .userAccountId(this.userAccountId)
                .totalPoints(this.totalPoints)
                .createTime(this.createTime)
                .updateTime(this.updateTime)
                .nickName(this.nickName)
                .phoneNum(this.phoneNum)
                .build();
    }
}
