package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.RealNameAuthDTO;
import com.mmc.iuav.user.model.dto.RealNameAuthDetailDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/7/27 14:49
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class RealNameAuthDO implements Serializable {
    private static final long serialVersionUID = -1752966940978678911L;
    private Integer id;
    private Integer cuId;
    private Integer userAccountId;
    private String frontIdImg;
    private String backIdImg;
    private String idNumber;
    private String userName;
    private Integer sex;
    private String nationality;
    private Date birthday;
    private String address;
    private String issue;
    private Date startDate;
    private Date endDate;
    private Integer fakeFront;
    private Integer fakeBack;
    private Integer checkStatus;
    private String remark;
    private Date createTime;
    private Date updateTime;
    private String uid;
    private String nickName;
    private String resAddress;
    private String phoneNum;
    private String unionId;

    public RealNameAuthDetailDTO buildRealNameAuthDetailDTO() {
        return RealNameAuthDetailDTO.builder().id(this.id).userAccountId(this.userAccountId).frontIdImg(this.frontIdImg)
                .backIdImg(this.backIdImg).idNumber(this.idNumber).userName(this.userName).checkStatus(this.checkStatus)
                .build();
    }

    public RealNameAuthDTO buildRealNameAuthDTO() {
        SimpleDateFormat cur = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return RealNameAuthDTO.builder().id(this.id).userAccountId(this.userAccountId).uid(this.userAccountId + "")
                .nickName(this.nickName).userName(this.userName).phoneNum(this.phoneNum).idNumber(this.idNumber)
                .resAddress(this.resAddress).checkStatus(this.checkStatus)
                .createTime((this.createTime == null) ? null : cur.format(this.createTime)).remark(this.remark).build();
    }
}
