package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.MenuInfoDTO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/7/11 14:49
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MenuInfoDO implements Serializable {
    private static final long serialVersionUID = -4992870152816350664L;
    private Integer id;
    private Integer pid;
    private String menuName;
    private String portType;
    private String domType;
    private String pathInfo;
    private String icon;
    private Integer sort;
    private Date createTime;
    private Date updateTime;

    public MenuInfoDTO buildMenuInfoDTO() {
        return MenuInfoDTO.builder().id(this.id).pid(this.pid).menuName(this.menuName).domType(this.domType)
                .pathInfo(this.pathInfo).icon(this.icon).build();
    }
}
