package com.mmc.iuav.user.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.auth.JwtConstant;
import com.mmc.iuav.auth.JwtUtil;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.auth.PwdUtil;
import com.mmc.iuav.user.client.PayClient;
import com.mmc.iuav.user.constant.WxConstant;
import com.mmc.iuav.user.dao.CompanyAuthDao;
import com.mmc.iuav.user.dao.RealNameAuthDao;
import com.mmc.iuav.user.dao.RoleDao;
import com.mmc.iuav.user.entity.*;
import com.mmc.iuav.user.enums.UserAccountStatus;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.LoginUserQO;
import com.mmc.iuav.user.model.vo.*;
import com.mmc.iuav.user.service.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author: zj
 * @Date: 2023/5/16 13:51
 */
@Slf4j
@Service
public class AuthServiceImpl implements AuthService {

    @Autowired
    private WxService wxService;

    @Autowired
    private UserAccountService userAccountService;

    @Autowired
    private BackUserAccountService backUserAccountService;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private CompanyAuthDao companyAuthDao;

    @Autowired
    private RoleDao roleDao;

    @Autowired
    private RealNameAuthDao realNameAuthDao;

    @Autowired
    private CompanyService companyService;

    @Autowired
    private PayClient payClient;

    @Transactional
    @Override
    public ResultBody appletLogin(WxLoginVO wxLoginVO) {
        String unionId;
        String openId;
        String sessionKey;
        if (wxLoginVO.getFromPort().toString().equals(WxConstant.APP.toString())) {
            //调用小程序登录接口，里面包含unionId
            String appWxJson = wxService.appLogin(wxLoginVO);
            if (StringUtils.isBlank(appWxJson)) {
                return ResultBody.error(ResultEnum.APPLET_PORT_TYPE_ERROR);
            }
            log.info("wx appLogin msg==>" + JSONObject.toJSONString(appWxJson));
            JSONObject json = JSON.parseObject(appWxJson);
            if (!json.containsKey(WxConstant.OPEN_ID) || !json.containsKey(WxConstant.SESSION_KEY)) {
                log.error("wx appLogin error==>" + JSONObject.toJSONString(json));
                return ResultBody.error(ResultEnum.APPLET_LOGIN_ERROR, json);
            }
            unionId = json.getString(WxConstant.UNION_ID);
            openId = json.getString(WxConstant.OPEN_ID);
            sessionKey = json.getString(WxConstant.SESSION_KEY);
        } else {
            return ResultBody.error(ResultEnum.PARAM_ERROR);
        }
        //数据库查询用户信息
        UserAccountVO userAccountVO = userAccountService.getUserAccountInfoByUnionId(unionId);
        Integer companyAuthStatus = 0;
        if (userAccountVO == null) {
            UserAccountDO userAccountDO = new UserAccountDO();
            userAccountDO.setUnionId(unionId);
            userAccountDO.setOpenId(openId);
            userAccountDO.setPortType(100);
            userAccountDO.setSource(wxLoginVO.getSource());
            userAccountService.insertUserAccount(userAccountDO);
            userAccountVO = userAccountDO.buildUserAccountVO();
            payClient.createWallet(userAccountDO.getId());
            // 查询之前有没有实名过
            RealNameAuthDO nameAuthByUnionId = realNameAuthDao.getRealNameAuthBakByUnionId(unionId);
            if (nameAuthByUnionId != null) {
                nameAuthByUnionId.setUserAccountId(userAccountDO.getId());
                nameAuthByUnionId.setId(null);
                realNameAuthDao.addRealNameAuth(nameAuthByUnionId);
            }
        } else {
            CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userAccountVO.getId());
            companyAuthStatus = companyAuthDO == null ? 0 : 1;
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put(JwtConstant.USER_ACCOUNT_ID, userAccountVO.getId());
        map.put(JwtConstant.TOKEN_TYPE, JwtConstant.IUAV_TOKEN);
        String token = JwtUtil.createJwt(map);
        LoginSuccessDTO loginSuccessDTO = LoginSuccessDTO.builder().token(token).userAccountId(userAccountVO.getId()).uid(userAccountVO.getId() + "")
                .userName(userAccountVO.getUserName()).nickName(userAccountVO.getNickName()).phoneNum(userAccountVO.getPhoneNum()).portType(100).build();

        stringRedisTemplate.opsForValue().set(
                token, JSONObject.toJSONString(loginSuccessDTO),
                JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);

        return ResultBody.success(AppUserSucVO.builder().token(token).uid(userAccountVO.getUid()).phoneNum(userAccountVO.getPhoneNum())
                .nickName(userAccountVO.getNickName()).userAccountId(userAccountVO.getId()).sessionKey(sessionKey).portType(100).authStatus(companyAuthStatus).build());
    }

    @Override
    public ResultBody backEndLogin(LoginUserQO param) {
        //查询用户信息
        BackUserAccountDO user = backUserAccountService.getUserLoginInfo(param.getAccountNo(), param.getPassWord());
        if (user == null) {
            return ResultBody.error(ResultEnum.LOGIN_ACCOUNT_NOT_EXIT_ERROR);
        }
        if (user.getAccountStatus().equals(UserAccountStatus.DISABLE.getAccountStatus())) {
            return ResultBody.error(ResultEnum.LOGIN_ACCOUNT_STATUS_ERROR);
        }
        String loginPwd = "";
        try {
            loginPwd = PwdUtil.securityPwd(param.getPassWord());
        } catch (NoSuchAlgorithmException e) {
            return ResultBody.error(ResultEnum.PWD_CONPARED_ERROR);
        }
        if (!loginPwd.equals(user.getPassword())) {
            return ResultBody.error(ResultEnum.LOGIN_PASSWORD_ERROR);
        }
        // 查询单位信息
        CompanyInfoVO companyInfoVO = companyService.getCompanyInfoByBackUserAccountId(user.getId());
        companyInfoVO.setLeader(1);
        // 角色信息
        RoleInfoDO roleInfoDO = roleDao.getRoleInfoByUserId(user.getId());
        Map<String, Object> map = new HashMap<String, Object>();
        map.put(JwtConstant.USER_ACCOUNT_ID, user.getId());
        map.put(JwtConstant.TOKEN_TYPE, JwtConstant.M_TOKEN);
        String token = JwtUtil.createJwt(map);
        LoginSuccessDTO loginSuccessDTO = LoginSuccessDTO.builder().token(token).userAccountId(user.getId()).accountNo(user.getAccountNo()).uid(user.getId() + "")
                .userName(user.getUserName()).nickName(user.getUserName()).phoneNum(user.getPhoneNum()).portType(0).companyInfoVO(companyInfoVO == null ? null : companyInfoVO)
                .roleInfo(roleInfoDO.buildRoleInfoDTO()).build();
        stringRedisTemplate.opsForValue().set(
                token, JSONObject.toJSONString(loginSuccessDTO),
                JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);
        loginSuccessDTO.setToken(token);
        return ResultBody.success(loginSuccessDTO);
    }

    @Override
    public ResultBody testAppletLogin(String unionId) {
        UserAccountVO userAccountVO = userAccountService.getUserAccountInfoByUnionId(unionId);
        if (userAccountVO != null) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put(JwtConstant.USER_ACCOUNT_ID, userAccountVO.getId());
            map.put(JwtConstant.TOKEN_TYPE, JwtConstant.IUAV_TOKEN);
            CompanyAuthDO companyAuthDO = companyAuthDao.getCompanyAuth(userAccountVO.getId());
            Integer companyAuthStatus = companyAuthDO == null ? 0 : 1;
            String token = JwtUtil.createJwt(map);
            LoginSuccessDTO loginSuccessDTO = LoginSuccessDTO.builder().token(token).userAccountId(userAccountVO.getId()).uid(userAccountVO.getId() + "")
                    .userName(userAccountVO.getUserName()).nickName(userAccountVO.getNickName()).phoneNum(userAccountVO.getPhoneNum()).portType(100).build();
            stringRedisTemplate.opsForValue().set(
                    token, JSONObject.toJSONString(loginSuccessDTO),
                    JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);

            return ResultBody.success(AppUserSucVO.builder().token(token).uid(userAccountVO.getUid()).phoneNum(userAccountVO.getPhoneNum())
                    .nickName(userAccountVO.getNickName()).userAccountId(userAccountVO.getId()).portType(100).authStatus(companyAuthStatus).build());
        }
        return ResultBody.error(ResultEnum.APPLET_LOGIN_ERROR);
    }

    @Override
    public ResultBody tempConfirmLogin(LoginSuccessDTO loginSuccessDTO, Integer port, String randomLoginCode) {
        if (port.equals(1)) {
            // 返回所属公司后台账号token
            CompanyInfoVO companyInfoVO = companyService.getAppCompanyInfoUId(loginSuccessDTO.getUserAccountId());
            if (companyInfoVO == null) {
                return ResultBody.error(ResultEnum.NOT_BINDING_COMPANY_ERROR);
            }
            // 查询所属单位
            CompanyBackUserDO companyBackUserDO = companyService.getCompanyBackUserByCompanyId(companyInfoVO.getId());
            if (companyBackUserDO == null) {
                return ResultBody.error(ResultEnum.NOT_BINDING_COMPANY_ERROR);
            }
            BackUserAccountVO backUserAccountVO = backUserAccountService.getBackUserAccountById(companyBackUserDO.getBackUserAccountId());
            if (backUserAccountVO.getDisable().equals(1)) {
                return ResultBody.error(ResultEnum.LOGIN_ACCOUNT_NOT_EXIT_ERROR);
            }
            // 设置用户角色
            RoleInfoDO roleInfoDO = roleDao.getRoleInfoByUserId(companyBackUserDO.getBackUserAccountId());

            Map<String, Object> map = new HashMap<String, Object>();
            map.put(JwtConstant.USER_ACCOUNT_ID, backUserAccountVO.getId());
            map.put(JwtConstant.TOKEN_TYPE, JwtConstant.M_TOKEN);
            String token = JwtUtil.createJwt(map);
            LoginSuccessDTO backLoginSuccessDTO = LoginSuccessDTO.builder().token(token).userAccountId(backUserAccountVO.getId())
                    .accountNo(backUserAccountVO.getAccountNo()).uid(backUserAccountVO.getId() + "").userName(backUserAccountVO.getUserName())
                    .nickName(backUserAccountVO.getUserName()).phoneNum(backUserAccountVO.getPhoneNum()).portType(0).companyInfoVO(companyInfoVO == null ? null : companyInfoVO)
                    .roleInfo(roleInfoDO.buildRoleInfoDTO()).appUserAccountId(loginSuccessDTO.getUserAccountId()).token(token).build();
            // 设置后台账号token，key为randomLoginCode
            stringRedisTemplate.opsForValue().set(
                    randomLoginCode, JSONObject.toJSONString(backLoginSuccessDTO),
                    JwtConstant.EXPIRATION, TimeUnit.MILLISECONDS);
            loginSuccessDTO.setToken(token);
        } else {
            stringRedisTemplate.opsForValue().set(
                    randomLoginCode, JSONObject.toJSONString(loginSuccessDTO),
                    JwtConstant.TEMP_EXPIRATION, TimeUnit.MILLISECONDS);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody getLoginInfo(String randomLoginCode) {
        String json = stringRedisTemplate.opsForValue().get(randomLoginCode);
        if (StringUtils.isBlank(json)) {
            return ResultBody.error(ResultEnum.APPLET_LOGIN_ERROR);
        }
        LoginSuccessDTO loginSuccessDTO = JSONObject.parseObject(json, LoginSuccessDTO.class);
        return ResultBody.success(loginSuccessDTO);
    }
}
