/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.exception;

import com.fadada.sdk.enums.ErrorMessage;
import org.apache.commons.lang3.StringUtils;

public class SDKException
extends Exception {
    private Integer code;
    private String message;

    public SDKException(Integer code, String message) {
        this.code = code;
        this.message = message;
    }

    public SDKException(Exception e, ErrorMessage errorMessage) {
        super(e);
        this.code = errorMessage.getCode();
        this.message = errorMessage.getMessage();
    }

    public SDKException(Exception e, ErrorMessage errorMessage, String message) throws SDKException {
        this.code = errorMessage.getCode();
        if (StringUtils.isNotBlank(message)) {
            errorMessage.setMessage(message);
        }
        throw new SDKException(e, errorMessage);
    }

    @Override
    public String getMessage() {
        return String.format("code:%s,message:%s", this.code, this.message);
    }

    public Integer getCode() {
        return this.code;
    }
}

