package com.mmc.iuav.user.controller;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.UserPartnerDO;
import com.mmc.iuav.user.model.qo.UserPartnerQO;

import com.mmc.iuav.user.model.vo.UserPartnerVO;
import com.mmc.iuav.user.service.UserPartnerService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;


/**
 * (UserPartner)表控制层
 *
 * @author makejava
 * @since 2024-03-18 18:09:51
 */
@Api(tags = "合伙人相关接口")
@RestController
@RequestMapping("/Partner/")
public class UserPartnerController extends BaseController {

    @Resource
    private UserPartnerService userPartnerService;


    @ApiOperation(value = "合伙人列表")
    @ApiResponses({@ApiResponse(code = 200, message = "success", response = UserPartnerDO.class)})
    @PostMapping("listPartner")
    public ResultBody queryByPage(@RequestBody UserPartnerQO userPartner) {
        return userPartnerService.queryByPage(userPartner);
    }


    @ApiOperation(value = "获取合伙人信息详情")
    @ApiResponses({@ApiResponse(code = 200, message = "success", response = UserPartnerDO.class)})
    @GetMapping("getPartnerInfo")
    public ResultBody<UserPartnerVO> queryById(@RequestParam Integer id) {
        return ResultBody.success(this.userPartnerService.queryById(id));
    }

    /**
     * 新增数据
     *
     * @param userPartnerDO 实体
     * @return 新增结果
     */
    @ApiOperation(value = "新增合伙人")
    @ApiResponses({@ApiResponse(code = 200, message = "success", response = UserPartnerDO.class)})
    @PostMapping("insertPartner")
    public ResultBody<UserPartnerDO> insertPartner(@RequestBody UserPartnerDO userPartnerDO, HttpServletRequest request) {
        Integer userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        userPartnerDO.setUserAccountId(userAccountId);
        return ResultBody.success(userPartnerService.insertPartner(userPartnerDO));
    }

    /**
     * 编辑数据
     *
     * @param userPartnerDO 实体
     * @return 编辑结果
     */
    @ApiOperation(value = "修改合伙人信息")
    @ApiResponses({@ApiResponse(code = 200, message = "success", response = UserPartnerDO.class)})
    @PostMapping("updatePartner")
    public ResultBody edit(@RequestBody UserPartnerDO userPartnerDO) {
        return ResultBody.success(userPartnerService.update(userPartnerDO));
    }

    /**
     * 删除数据
     *
     * @param id 主键
     * @return 删除是否成功
     */
    @ApiOperation(value = "删除合伙人信息")
    @ApiResponses({@ApiResponse(code = 200, message = "success", response = UserPartnerDO.class)})
    @PostMapping("deletePartner")
    public ResultBody deleteById(Integer id) {
        return this.userPartnerService.deleteById(id);
    }

}

