package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.entity.UserRcdDO;
import com.mmc.iuav.user.entity.data.ActiveUserCountDO;
import com.mmc.iuav.user.entity.fdd.UserFddDO;
import com.mmc.iuav.user.model.dto.UserBaseInfoDTO;
import com.mmc.iuav.user.model.qo.UserAccountQO;
import com.mmc.iuav.user.model.qo.UserMessageQO;
import com.mmc.iuav.user.model.qo.UserRcdQO;
import com.mmc.iuav.user.model.vo.UserAccountMessageVo;
import io.swagger.models.auth.In;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 19:26
 */
@Mapper
public interface UserServiceDao {
    /**
     * 根据用户unionId查询用户信息
     *
     * @param unionId
     * @return
     */
    UserAccountDO getUserAccountInfoByUnionId(String unionId);

    /**
     * 插入用户信息
     *
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);
    Integer insertUserAccount1(UserAccountDO userAccountDO);

    /**
     * 根据用户id查询用户信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountDO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     *
     * @param userAccountDO
     */
    void update(UserAccountDO userAccountDO);

    void updateId(@Param("userAccountDO") UserAccountDO userAccountDO,@Param("newId") Integer newId);
    /**
     * 查询是否存在这个用户
     * @param userId 用户id
     * @return {@link Integer} 1存在
     */
    Integer getCountUser(Integer userId);
    /**
     * 根据用户地区查询后台用户id
     *
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> listUserAccountIdsByDistrictCode(Integer provinceCode, Integer cityCode, Integer districtCode);

    /**
     * 批量获取用户信息
     *
     * @param userAccountQO
     * @return
     */
    List<UserAccountDO> feignListUserAccount(UserAccountQO userAccountQO);

    /**
     * 禁用用户（原删除）
     *
     * @param removeNO
     * @param userAccountId
     */
    void disableUserAccount(String removeNO, Integer userAccountId);

    /**
     * 根据id查询用户信息
     *
     * @param userIds
     * @return
     */
    List<UserAccountDO> listUserAccountByIds(@Param("userIds") List<Integer> userIds);

    /**
     * 获取用户推荐人信息
     *
     * @param userIds
     * @return
     */
    List<UserAccountDO> feignListRcdUserInfo(@Param("userIds") List<Integer> userIds);

    /**
     * 获取推荐人信息
     *
     * @param userAccountId
     * @return
     */
    UserAccountDO getUserRcdByAccountId(Integer userAccountId);

    /**
     * 获取用户推荐信息
     *
     * @param userAccountId
     * @return
     */
    UserRcdDO getUserRcdDO(Integer userAccountId);

    /**
     * 用户数量
     *
     * @param param
     * @return
     */
    int countListAppUser(UserAccountQO param);

    /**
     * 用户信息
     *
     * @param param
     * @return
     */
    List<UserAccountDO> listAppUser(UserAccountQO param);

    /**
     * 添加邀请信息
     *
     * @param userRcd
     */
    void insertUserRcd(UserRcdDO userRcd);

    /**
     * 邀请人数
     *
     * @param userAccountId
     * @return
     */
    int countRcd(Integer userAccountId);

    /**
     * 邀请列表
     *
     * @param userRcdQO
     * @return
     */
    List<UserAccountDO> listUserRcd(UserRcdQO userRcdQO);

    /**
     * 邀请排行榜
     *
     * @param topNum
     * @return
     */
    List<UserAccountDO> topRcd(Integer topNum);

    /**
     * 查询用户推荐个数
     *
     * @param uIds
     * @return
     */
    List<UserAccountDO> getInviteCount(@Param("uIds") List<Integer> uIds);

    /**
     * 根据手机号查询用户信息
     *
     * @param phoneNum
     * @return
     */
    List<UserAccountDO> getUserAccountByPhoneNum(String phoneNum);

    UserAccountDO getUserAccountInfoByOpenId(String openid);

    List<UserFddDO> listUserFddInfo(@Param(value = "unionId") String unionId, @Param(value = "openid") String openid);

    int getUsableUserCount();

    int getYesterdayAddUserCount();

    void insertActiveUserCount(ActiveUserCountDO activeUserCountDO);

    ActiveUserCountDO getActiveUserCountByDayNum();


    Integer countPhoneNum(String phoneNum);

    int countPhoneNums(String phoneNum, Integer userAccountId);

    void updateAccountPhone(Integer userAccountId, String phoneNum);

    void appUpdateUser(UserMessageQO userMessageQO);

    int selectUserAccount(UserMessageQO userMessageQO);

    int selectUserAccountNickName(UserAccountDO userAccountDO);

    String getDistrictChild(Integer districtChildId);

    UserAccountMessageVo userMessages(Integer userAccountId);

    List<String> userMessagesPilot(Integer pilotId);

    List<UserAccountDO> listAllUserAccountByIds(@Param("userIds") List<Integer> ids);

    int appUserCompanyAuthCount();

    /**
     * 查询该用户是否被邀请过了
     * @param userId 用户id
     * @return {@link Integer} 1表示被邀请过了 0表示没有
     */
    Integer getCountUserByUserCrd(Integer userId);


    /**
     * 根据用户的id获取用户的基本信息
     * @param userAccountId 用户id
     * @return {@link UserBaseInfoDTO}
     */
    UserBaseInfoDTO getUserBaseInfo(Integer userAccountId);

    /**
     * 通过用户id获取用户的电话号码
     * @param userId 用户的id
     * @return {@link String}
     */
    String getUserPhoneByUserId(Integer userId);

    /**
     * 根据手机号查询unionId
     */
    String selectUnionIdByPhone(String phone);

    /**
     * 根据手机号查询用户信息
     *
     * @param phoneNum
     * @return
     */
    UserAccountDO getUserByPhoneNum(String phoneNum);

    /**
     * 删除用户信息
     */
    void deleteById(Integer id);


    UserAccountDO getUserAccountInfoByPhoneNum(String phoneNum);
}
