package com.mmc.iuav.user.controller.fdd;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.fdd.vo.ContractVO;
import com.mmc.iuav.user.service.fdd.ContractService;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author LW
 * @date 2022/9/5 14:31
 * 概要：
 */
@Api(tags = {"无人机城--合同管理" })
@RestController
@RequestMapping("/uav/contract/")
public class ContractController extends BaseController {
    @Autowired
    private ContractService contractService;

    @ApiOperation(value = "上传合同")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/uploadContract")
    public ResultBody uploadContract(@RequestBody ContractVO param, HttpServletRequest request) {
        return contractService.uploadContract(param, this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "合同预览")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/viewContract")
    public ResultBody viewContract(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId) {
        return contractService.viewContract(contractId);
    }

    @ApiOperation(value = "下载合同")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/downloadContract")
    public ResultBody downloadContract(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId) {
        return contractService.downloadContract(contractId);
    }

    @ApiOperation(value = "手动签署")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/stamp")
    public ResultBody stamp(@ApiParam(value = "合同编号") @RequestParam(value = "contractId") String contractId,
                            @ApiParam(value = "小程序页面跳转地址") @RequestParam(value = "pages", required = false) String pages,
                            HttpServletRequest request, @ApiParam(value = "端口：0小程序 1后台") @RequestParam(value = "port") Integer port) {
        return contractService.stamp(contractId, this.getUserLoginInfoFromRedis(request), pages, port);
    }
//
//    @ApiOperation(value = "异步处理手动签署信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @PostMapping("notifyStamp")
//    @ApiIgnore
//    public ResultBody notifyStamp(@RequestParam Map<String, String> map) {
//        return uavContractManageService.notifyStamp(map);
//    }
//
//    @ApiOperation(value = "合同签署信息-条件查询")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @PostMapping("selectList")
//    public ResultBody<List<UavContractInfoDTO>> selectList(@RequestBody UavContractInfoQO qo) {
//        return uavContractManageService.selectList(qo);
//    }*
//
//    @ApiOperation(value = "归档")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @GetMapping("/file")
//    public ResultBody file(@RequestParam(value = "contractId") String contractId, HttpServletRequest request) {
//        return uavContractManageService.file(contractId, this.getCurrentAccount(request).getId());
//    }
//
//    @ApiOperation(value = "通过无人机城订单id批量查询合同信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @ApiIgnore
//    @PostMapping("feignListUAVContractByOIds")
//    public List<UavContractInfoDTO> feignListUAVContractByOIds(@RequestBody List<Long> orderIds) {
//        return uavContractManageService.feignListUAVContractByOIds(orderIds);
//    }
//
//    @ApiOperation(value = "通过无人机城订单id单个合同信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @ApiIgnore
//    @GetMapping("feignGetUAVContractByOId")
//    public UavContractInfoDTO feignGetUAVContractByOId(@RequestParam Long orderId) {
//        return uavContractManageService.feignGetUAVContractByOId(orderId);
//    }
//
//    @ApiOperation(value = "根据orderId删除合同信息")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @ApiIgnore
//    @GetMapping("feignRemoveContractByOrderId")
//    public ResultBody feignRemoveContractByOrderId(@RequestParam Long orderId) {
//        return uavContractManageService.feignRemoveContractByOrderId(orderId);
//    }
//


}
