package com.mmc.iuav.user.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.mmc.iuav.auth.JwtConstant;
import com.mmc.iuav.auth.JwtUtil;
import com.mmc.iuav.general.CodeUtil;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.constant.WxConstant;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.model.vo.AppUserSucVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.AuthService;
import com.mmc.iuav.user.service.UserAccountService;
import com.mmc.iuav.user.service.WxService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: zj
 * @Date: 2023/5/16 13:51
 */
@Slf4j
@Service
public class AuthServiceImpl implements AuthService {

    @Autowired
    private WxService wxService;

    @Autowired
    private UserAccountService userAccountService;

    @Override
    public ResultBody appletLogin(WxLoginVO wxLoginVO) {
        String unionId;
        String openId;
        if (wxLoginVO.getFromPort().toString().equals(WxConstant.APP.toString())) {
            //调用小程序登录接口，里面包含unionId
            String appWxJson = wxService.appLogin(wxLoginVO);
            if (appWxJson == null) {
                return ResultBody.error(ResultEnum.APPLET_PORT_TYPE_ERROR);
            }
            JSONObject json = JSON.parseObject(appWxJson);
            if (!json.containsKey(WxConstant.OPEN_ID) || !json.containsKey(WxConstant.SESSION_KEY)) {
                log.error("wx appLogin error==>" + json);
                return ResultBody.error(ResultEnum.APPLET_LOGIN_ERROR, json);
            }
            unionId = json.getString(WxConstant.UNION_ID);
            openId = json.getString(WxConstant.OPEN_ID);
        }else if (wxLoginVO.getFromPort().equals(WxConstant.WEB)){
            //获取access_token接口，里面包含unionId
            String pcWxJson = wxService.pcLogin(wxLoginVO);
            if (pcWxJson == null) {
                return ResultBody.error(ResultEnum.APPLET_PORT_TYPE_ERROR);
            }
            JSONObject json = JSON.parseObject(pcWxJson);
            if (!json.containsKey(WxConstant.OPEN_ID) ||!json.containsKey(WxConstant.SESSION_KEY)) {
                log.error("wx pcLogin error==>" + json);
                return ResultBody.error(ResultEnum.APPLET_LOGIN_ERROR, json);
            }
            unionId = json.getString(WxConstant.UNION_ID);
            openId = json.getString(WxConstant.OPEN_ID);
        }else {
            return ResultBody.error(ResultEnum.PARAM_ERROR);
        }
        //数据库查询用户信息
        UserAccountVO userAccountVO = userAccountService.getUserAccountInfoByUnionId(unionId);
        if (userAccountVO == null) {
            UserAccountDO userAccountDO = new UserAccountDO();
            userAccountDO.setUnionId(unionId);
            userAccountDO.setOpenId(openId);
            userAccountDO.setUid(CodeUtil.generateUserUID());
            userAccountDO.setAccountType(0);
            userAccountDO.setPortType(100);
            userAccountDO.setSource(wxLoginVO.getSource());
            userAccountService.insertUserAccount(userAccountDO);
            userAccountVO = userAccountDO.buildUserAccountVO();
        }
        Map<String, Object> map = new HashMap<String, Object>();
        map.put(JwtConstant.USER_ACCOUNT_ID, userAccountVO.getId());
        map.put(JwtConstant.ROLE_ID, 0);
        map.put(JwtConstant.TOKEN_TYPE, JwtConstant.IUAV_TOKEN);
        String token = JwtUtil.createJwt(map);

        return ResultBody.success(AppUserSucVO.builder().token(token).userAccountId(userAccountVO.getId()).build());
    }
}
