package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.UserPartnerDO;
import com.mmc.iuav.user.dao.UserPartnerDao;
import com.mmc.iuav.user.model.qo.UserPartnerQO;
import com.mmc.iuav.user.model.vo.UserPartnerVO;
import com.mmc.iuav.user.service.UserPartnerService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * (UserPartner)表服务实现类
 *
 * @author makejava
 * @since 2024-03-18 18:09:51
 */
@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
public class UserPartnerServiceImpl implements UserPartnerService {
    @Autowired
    private UserPartnerDao userPartnerDao;

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    @Override
    public UserPartnerVO queryById(Integer id) {
        return userPartnerDao.queryById(id);
    }

    /**
     * 分页查询
     *
     * @param userPartner 筛选条件
     * @return 查询结果
     */
    @Override
    public ResultBody queryByPage(UserPartnerQO userPartner) {
        int total = userPartnerDao.count(userPartner);



        int pageNo = userPartner.getPageNo();
        userPartner.buildCurrentPage();
        List<UserPartnerVO> userPartnerDOS = userPartnerDao.queryAllByLimit(userPartner);
        return ResultBody.success(PageResult.buildPage(pageNo, userPartner.getPageSize(), total, userPartnerDOS));
    }

    /**
     * 新增数据
     *
     * @param userPartnerDO 实例对象
     * @return 实例对象
     */
    @Override
    public UserPartnerDO insertPartner(UserPartnerDO userPartnerDO) {
        userPartnerDao.insertPartner(userPartnerDO);
        return userPartnerDO;
    }

    /**
     * 修改数据
     *
     * @param userPartnerDO 实例对象
     * @return 实例对象
     */
    @Override
    public ResultBody update(UserPartnerDO userPartnerDO) {
        userPartnerDao.update(userPartnerDO);
        return ResultBody.success();
    }

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    @Override
    public ResultBody deleteById(Integer id) {
        if (userPartnerDao.deleteById(id) > 0) {
            return ResultBody.success();
        }
        return ResultBody.error("删除失败");
    }
}
