package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.UserAccountDO;
import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.qo.LoginUserQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/5/16 13:48
 */
public interface UserAccountService {
    /**
     * Get the user account
     * @param unionId
     * @return
     */
    UserAccountVO getUserAccountInfoByUnionId(String unionId);

    /**
     * Insert the user account
     * @param userAccountDO
     */
    void insertUserAccount(UserAccountDO userAccountDO);

    /**
     * 通过用户id获取用户信息
     * @param userAccountId
     * @return
     */
    UserAccountVO getUserAccountById(Integer userAccountId);

    /**
     * 修改用户信息
     * @param userAccountVO
     * @return
     */
    ResultBody update(UserAccountVO userAccountVO);

    /**
     * 获取用户基本信息
     * @param userAccountId
     * @return
     */
    UserAccountSimpleDTO getUserSimpleInfo(Integer userAccountId);

    /**
     * 根据用户地区查询后台用户id
     * @param provinceCode
     * @param cityCode
     * @param districtCode
     * @return
     */
    List<Integer> feignListUserAccountIds(Integer provinceCode, Integer cityCode, Integer districtCode);

    /**
     * 添加后台用户
     * @param bUserAccountVO
     * @return
     */
    ResultBody insertBAccount(BUserAccountVO bUserAccountVO);

    /**
     * 删除用户信
     * @param userAccountId
     * @return
     */
    ResultBody removeBAccount(Integer userAccountId);

    /**
     * 后台用户列表
     * @param bUserAccountQO
     * @return
     */
    ResultBody listBAccountPage(BUserAccountQO bUserAccountQO);

    /**
     * 登录账号密码查询用户信息
     * @param accountNo
     * @param passWord
     * @return
     */
    UserAccountDO getUserLoginInfo(String accountNo, String passWord);

    /**
     * 内部获取用户列表
     * @param bUserAccountQO
     * @return
     */
    List<UserAccountSimpleDTO> feignListBAccountPage(BUserAccountQO bUserAccountQO);

    /**
     * 修改用户信息
     * @param bUserAccountVO
     * @return
     */
    ResultBody updateBAccount(BUserAccountVO bUserAccountVO);

    /**
     * 修改用户密码
     * @param account
     * @return
     */
    ResultBody updatePassword(BUserAccountVO account);

    /**
     * 验证用户密码
     * @param id
     * @param authPwd
     * @return
     */
    ResultBody feignAuthUserPwd(Integer id, String authPwd);

    /**
     * 授权手机号
     * @param id
     * @param code
     * @return
     */
    ResultBody getUserPhoneNumber(Integer id, String code);
}
