package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.http.HttpsRequestUtil;
import com.mmc.iuav.user.constant.UserSystemConstant;
import com.mmc.iuav.user.constant.WxConstant;
import com.mmc.iuav.user.model.vo.WxLoginVO;
import com.mmc.iuav.user.service.WxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author: zj
 * @Date: 2023/5/16 13:44
 */
@Service
public class WxServiceImpl implements WxService {
    @Autowired
    private UserSystemConstant userSystemConstant;

    @Override
    public String appLogin(WxLoginVO wxLoginVO) {
        String url = WxConstant.CODE2_SESSION_URL + "?appid=" + userSystemConstant.getWxAppId() + "&secret=" + userSystemConstant.getWxAppSecret() + "&js_code=" + wxLoginVO.getCode()
                + "&grant_type=" + WxConstant.GRANT_TYPE;
        String data = HttpsRequestUtil.httpsGet(url, null);
        return data;
    }

    @Override
    public String pcLogin(WxLoginVO wxLoginVO) {
        String url = WxConstant.ACCESS_TOKEN_URL + "?appid=" + userSystemConstant.getWxAppId() + "&secret=" + userSystemConstant.getWxAppSecret() + "&code=" + wxLoginVO.getCode()
                + "&grant_type=" + WxConstant.GRANT_TYPE;
        String data = HttpsRequestUtil.httpsGet(url, null);
        return data;
    }

    @Override
    public String getAccessToken() {
        //token有效期为7200s，需要保存起来
        return null;
    }
}
