package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author: zj
 * @Date: 2023/6/21 15:35
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class BackUserAccountDO implements Serializable {
    private static final long serialVersionUID = 258826882034224799L;
    private Integer id;
    private String accountNo;
    private String password;
    private String phoneNum;
    private String userName;
    private Integer userSex;
    private String email;
    private Integer accountStatus;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;
    private Integer deleted;
    private Date createTime;
    private Date updateTime;
    private String remark;
    private String address;
    private RoleInfoDO roleInfoDO;

    public BackUserAccountDO(BUserAccountVO bUserAccountVO) {
        this.id = bUserAccountVO.getId();
        this.accountNo = bUserAccountVO.getAccountNo();
        this.phoneNum = bUserAccountVO.getPhoneNum();
        this.userName = bUserAccountVO.getUserName();
        this.email = bUserAccountVO.getEmail();
        this.provinceCode = bUserAccountVO.getProvinceCode();
        this.cityCode = bUserAccountVO.getCityCode();
        this.districtCode = bUserAccountVO.getDistrictCode();
        this.remark = bUserAccountVO.getRemark();
        this.address = bUserAccountVO.getAddress();
    }

    public BackUserAccountVO buildBackUserAccountVO() {
        return BackUserAccountVO.builder().id(this.id).uid(this.id).accountNo(this.accountNo).phoneNum(this.phoneNum)
                .userName(this.userName).userSex(this.userSex).email(this.email).accountStatus(this.accountStatus)
                .remark(this.remark).address(this.address).createTime(this.createTime)
                .roleInfoDTO(this.roleInfoDO == null ? null : this.roleInfoDO.buildRoleInfoDTO()).build();
    }
}
