package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.general.CodeUtil;
import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.auth.PwdUtil;
import com.mmc.iuav.user.dao.BackUserAccountDao;
import com.mmc.iuav.user.entity.BackUserAccountDO;
import com.mmc.iuav.user.entity.CompanyBackUserDO;
import com.mmc.iuav.user.model.qo.BUserAccountQO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.BackUserAccountVO;
import com.mmc.iuav.user.service.BackUserAccountService;
import com.mmc.iuav.user.service.CompanyService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/6/21 15:48
 */
@Service
public class BackUserAccountServiceImpl implements BackUserAccountService {
    @Autowired
    private BackUserAccountDao backUserAccountDao;

    @Autowired
    private CompanyService companyService;

    @Override
    public ResultBody insertBAccount(BUserAccountVO bUserAccountVO) {
        if (!bUserAccountVO.getPassWord().equals(bUserAccountVO.getAlertPwd())) {
            // 两次密码不一致
            return ResultBody.error(ResultEnum.PWD_ALERT_ERROR);
        }
        // 获取新增的账户名是否已经存在
        int count = backUserAccountDao.countUserAccountNo(null, bUserAccountVO.getAccountNo());
        if (count > 0) {
            return ResultBody.error(ResultEnum.ADD_USER_ACCOUNT_NAME_EXISTS);
        }
        BackUserAccountDO backUserAccountDO = new BackUserAccountDO(bUserAccountVO);
        try {
            backUserAccountDO.setPassword(PwdUtil.securityPwd(bUserAccountVO.getPassWord()));
        } catch (NoSuchAlgorithmException e) {
            return ResultBody.error(ResultEnum.PWD_CREATE_ERROR);
        }
        backUserAccountDao.insertBackUserAccount(backUserAccountDO);
        // 添加单位信息
        if (bUserAccountVO.getCompanyId() != null){
            CompanyBackUserDO companyBackUserDO = new CompanyBackUserDO();
            companyBackUserDO.setBackUserAccountId(backUserAccountDO.getId());
            companyBackUserDO.setCompanyInfoId(bUserAccountVO.getCompanyId());
            companyService.addCompanyBackUser(companyBackUserDO);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody updateBAccount(BUserAccountVO bUserAccountVO) {
        // 判断账号是否重复
        if (!StringUtils.isEmpty(bUserAccountVO.getAccountNo())) {
            // 如果传入的名字不为空，就查找数据库，看名字是否重复
            int count = backUserAccountDao.countUserAccountNo(bUserAccountVO.getId(), bUserAccountVO.getAccountNo());
            if (count > 0) {
                return ResultBody.error(ResultEnum.UPDATE_USER_ACCOUNT_REPEAT);
            }
        }
        BackUserAccountDO userAccountDO = new BackUserAccountDO(bUserAccountVO);
        backUserAccountDao.updateBackUserAccount(userAccountDO);
        // 修改单位信息
        if (bUserAccountVO.getCompanyId() != null){
            CompanyBackUserDO companyBackUserDO = new CompanyBackUserDO();
            companyBackUserDO.setBackUserAccountId(userAccountDO.getId());
            companyBackUserDO.setCompanyInfoId(bUserAccountVO.getCompanyId());
            companyService.updateCompanyBackUser(companyBackUserDO);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody removeBAccount(Integer userAccountId) {
        backUserAccountDao.removeBackUserAccountDO(userAccountId);
        return ResultBody.success();
    }

    @Override
    public ResultBody<BackUserAccountVO> listBAccountPage(BUserAccountQO param) {
        int count = backUserAccountDao.countListBackUserAccount(param);
        if (count == 0) {
            return ResultBody.success(PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<BackUserAccountDO> users = backUserAccountDao.listBackUserAccount(param);
        List<BackUserAccountVO> collect = users.stream().map(BackUserAccountDO::buildBackUserAccountVO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, collect));
    }

    @Override
    public List<BackUserAccountVO> feignListBAccountPage(BUserAccountQO bUserAccountQO) {
        List<BackUserAccountDO> list = backUserAccountDao.feignListBackUserAccount(bUserAccountQO);
        if (list == null) {
            return null;
        }
        List<BackUserAccountVO> accountSimpleDTOS = list.stream().map(BackUserAccountDO::buildBackUserAccountVO).collect(Collectors.toList());
        return accountSimpleDTOS;
    }

    @Override
    public ResultBody updatePassword(BUserAccountVO account) {
        if (!account.getPassWord().equals(account.getAlertPwd())) {
            return ResultBody.error(ResultEnum.PASSWORD_INCONSISTENT);
        }
        try {
            account.setPassWord(PwdUtil.securityPwd(account.getPassWord()));
            backUserAccountDao.updatePassword(account.getId(), account.getPassWord());
        } catch (NoSuchAlgorithmException e) {
            return ResultBody.error(ResultEnum.PWD_CONPARED_ERROR);
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody feignAuthUserPwd(Integer id, String authPwd) {
        BackUserAccountDO account = backUserAccountDao.getAuthUserPwd(id);
        if (account == null) {
            return ResultBody.error(ResultEnum.LOGIN_ACCOUNT_NOT_EXIT_ERROR);
        }
        String pwd = "";
        try {
            pwd = PwdUtil.securityPwd(authPwd);
        } catch (NoSuchAlgorithmException e) {
            return ResultBody.error(ResultEnum.PWD_CREATE_ERROR);
        }
        if (!pwd.equals(account.getPassword())) {
            return ResultBody.error(ResultEnum.PWD_CONPARED_ERROR);
        }
        return ResultBody.success();
    }

    @Override
    public BackUserAccountDO getUserLoginInfo(String accountNo, String passWord) {
        BackUserAccountDO userLoginInfo = backUserAccountDao.getUserLoginInfo(accountNo, passWord);
        return userLoginInfo;
    }
}
