package com.mmc.iuav.user.service;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.entity.CompanyBackUserDO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
public interface CompanyService {
    /**
     * 新增
     * @param companyInfo
     * @return
     */
    ResultBody addCompanyInfo(CompanyInfoVO companyInfo);

    /**
     * 移除
     * @param id
     * @param token
     * @return
     */
    ResultBody removeCompanyInfo(Integer id, String token);

    /**
     * 修改
     * @param companyInfo
     * @return
     */
    ResultBody updateCompanyInfo(CompanyInfoVO companyInfo);

    /**
     * 单位查询
     * @param id
     * @return
     */
    ResultBody getCompanyInfoById(Integer id);

    /**
     * 单位列表
     * @param companyInfoQO
     * @return
     */
    ResultBody<CompanyInfoVO> listCompanyPage(CompanyInfoQO companyInfoQO);

    /**
     * 通过用户id获取单位信息
     * @param backUserAccountId
     * @return
     */
    CompanyInfoVO getCompanyInfoByBackUserAccountId(Integer backUserAccountId);

    /**
     * 添加绑定关系
     * @param companyBackUserDO
     */
    void addCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    /**
     * 修改绑定关系
     * @param companyBackUserDO
     */
    void updateCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    List<CompanyInfoVO> listCompanyPageBack(CompanyInfoQO companyInfoQO);
}
