package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * @author: zj
 * @Date: 2023/7/3 15:56
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CompanyInfoDO implements Serializable {
    private static final long serialVersionUID = -533935402556556571L;
    private Integer id;
    private Integer companyType;
    private String companyName;
    private String fullName;
    private String province;
    private String city;
    private String district;
    private String address;
    private String companyUserName;
    private String phoneNum;
    private String remark;

    public CompanyInfoVO buildCompanyInfoVO() {
        return CompanyInfoVO.builder().id(id).companyType(companyType).companyName(companyName).fullName(fullName).province(province)
                .city(city).district(district).address(address).companyUserName(companyUserName).phoneNum(phoneNum).remark(remark).build();
    }

    public CompanyInfoDO(CompanyInfoVO companyInfo) {
        this.id = companyInfo.getId();
        this.companyType = companyInfo.getCompanyType();
        this.companyName = companyInfo.getCompanyName();
        this.fullName = companyInfo.getFullName();
        this.province = companyInfo.getProvince();
        this.city = companyInfo.getCity();
        this.district = companyInfo.getDistrict();
        this.address = companyInfo.getAddress();
        this.companyUserName = companyInfo.getCompanyUserName();
        this.phoneNum = companyInfo.getPhoneNum();
        this.remark = companyInfo.getRemark();
    }
}
