package com.mmc.iuav.user.controller;

import com.mmc.iuav.group.Insert;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import com.mmc.iuav.user.service.CompanyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/3 15:35
 */
@Api(tags = "单位管理")
@RequestMapping("/company/")
@RestController
public class CompanyController extends BaseController{
    @Autowired
    private CompanyService companyService;

    @ApiOperation(value = "新增")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("add")
    public ResultBody add(@Validated(Insert.class) @RequestBody CompanyInfoVO companyInfo){
        return companyService.addCompanyInfo(companyInfo);
    }

    @ApiOperation(value = "移除")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @GetMapping("remove")
    public ResultBody remove(@RequestParam Integer id, @RequestHeader String token){
        return companyService.removeCompanyInfo(id, token);
    }

    @ApiOperation(value = "修改")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = ResultBody.class) })
    @PostMapping("update")
    public ResultBody update(@RequestBody CompanyInfoVO companyInfo){
        return companyService.updateCompanyInfo(companyInfo);
    }

    @ApiOperation(value = "单位查询")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CompanyInfoVO.class) })
    @GetMapping("getCompanyInfoById")
    public ResultBody<CompanyInfoVO> getCompanyInfoById(@RequestParam Integer id){
        return companyService.getCompanyInfoById(id);
    }

    @ApiOperation(value = "单位列表")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CompanyInfoVO.class) })
    @PostMapping("listCompanyPage")
    public ResultBody<CompanyInfoVO> listCompanyPage(@RequestBody CompanyInfoQO companyInfoQO){
        return companyService.listCompanyPage(companyInfoQO);
    }

    @ApiIgnore
    @ApiOperation(value = "单位列表-后台使用")
    @ApiResponses({ @ApiResponse(code = 200, message = "OK", response = CompanyInfoVO.class) })
    @PostMapping("listCompanyPageBack")
    public List<CompanyInfoVO> listCompanyPageBack(@RequestBody CompanyInfoQO companyInfoQO){
        return companyService.listCompanyPageBack(companyInfoQO);
    }
    
}
