package com.mmc.iuav.user.controller.xzsz;

import cn.hutool.json.JSONObject;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.controller.BaseController;
import com.mmc.iuav.user.model.vo.XzAuthVO;
import com.mmc.iuav.user.model.vo.XzWithdrawalVO;
import com.mmc.iuav.user.service.xzsz.XzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

/**
 * @author: zj
 * @Date: 2023/8/20 14:01
 */
@Slf4j
@Api(tags = "小猪算账api")
@RequestMapping("/xz/")
@RestController
public class XzController extends BaseController {

    @Autowired
    private XzService xzService;

    @ApiOperation(value = "税源地公司信息查询-V2")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getTaxFundList")
    public ResultBody getTaxFundList() {
        return xzService.getTaxFundList();
    }

    @ApiOperation(value = "资金池汇总余额查询-V2")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getCashPooling")
    public ResultBody getCashPooling() {
        return xzService.getCashPooling();
    }

    @ApiOperation(value = "查询税源地可用资金-V2")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getUsableCashPooling")
    public ResultBody getUsableCashPooling() {
        return ResultBody.success(xzService.getUsableCashPooling());
    }

    @ApiOperation(value = "签约状态查询")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getContractScope")
    public ResultBody getContractScope(@RequestBody XzAuthVO xzAuthVO) {
        return ResultBody.success(xzService.getContractScope(xzAuthVO));
    }

    @ApiOperation(value = "发起合同签署")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("hasKeyByUrl")
    public ResultBody hasKeyByUrl(HttpServletRequest request) {
        return ResultBody.success(xzService.hasKeyByUrl(this.getUserLoginInfoFromRedis(request)));
    }

    @ApiOperation(value = "查询签署结果")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("getSignedResult")
    public ResultBody getSignedResult(@RequestBody XzAuthVO xzAuthVO) {
        return ResultBody.success(xzService.getSignedResult(xzAuthVO));
    }

    @ApiOperation(value = "在线浏览合同")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("viewContract")
    public ResultBody viewContract(@RequestParam String documentId) {
        return ResultBody.success(xzService.viewContract(documentId));
    }

    @ApiOperation(value = "刷脸数据删除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("clearTestFace")
    public ResultBody clearTestFace(@RequestParam String name, @RequestParam String idCard) {
        return xzService.clearTestFace(name, idCard);
    }

    @ApiOperation(value = "特殊单笔提现上报")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("singleSubmitLimit")
    public ResultBody singleSubmitLimit(@RequestBody XzWithdrawalVO xzWithdrawalVO) {
        return ResultBody.success(xzService.singleSubmitLimit(xzWithdrawalVO));
    }

    @ApiOperation(value = "单笔提现上报")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("singleSubmit")
    public ResultBody singleSubmit(@RequestBody XzWithdrawalVO xzWithdrawalVO) {
        return ResultBody.success(xzService.singleSubmit(xzWithdrawalVO));
    }

    @ApiOperation(value = "查询提现结果")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("querySingleTrade")
    public ResultBody querySingleTrade(@RequestParam String outerTradeNo) {
        return ResultBody.success(xzService.querySingleTrade(outerTradeNo));
    }

    @ApiOperation(value = "查询单笔交易回单")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("querySingleReceipt")
    public ResultBody querySingleReceipt(@RequestParam String frontLogNo) {
        return xzService.querySingleReceipt(frontLogNo);
    }

    @ApiOperation(value = "签署结果回调")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("xzAuthNotify")
    public String xzAuthNotify(@RequestBody JSONObject notify) {
        return xzService.xzAuthNotify(notify);
    }

    @ApiOperation(value = "回调通知（单笔）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("xzWithdrawNotify")
    public String xzWithdrawNotify(@RequestBody JSONObject notify) {
        return xzService.xzWithdrawNotify(notify);
    }

}
