package com.mmc.iuav.user.entity;


import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;


/**
 * @author Admin
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserDO implements Serializable {
    private static final long serialVersionUID = 5007589179946146721L;
    @ApiModelProperty(value = "用户ID")
    private Integer userAccountId;
    @ApiModelProperty(value = "用户姓名")
    private String userName;
    @ApiModelProperty(value = "用户昵称")
    private String nickName;
    @ApiModelProperty(value = "头像")
    private String userImg;
    @ApiModelProperty(value = "未读的消息个数")
    private Integer unreadCount;
    @ApiModelProperty(value = "手机号")
    private String phoneNum;
    @ApiModelProperty(value = "最新消息")
    private String endMessage;
    @ApiModelProperty(value = "最新消息创建时间")
    private Date createTime;

    private CompanyInfoVO companyInfoVO;
}
