package com.mmc.iuav.user.service.impl;

import com.mmc.iuav.page.PageResult;
import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import com.mmc.iuav.user.client.PmsClient;
import com.mmc.iuav.user.dao.CompanyDao;
import com.mmc.iuav.user.entity.CompanyBackUserDO;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import com.mmc.iuav.user.model.vo.CompanyInfoVO;
import com.mmc.iuav.user.service.CompanyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
@Service
public class CompanyServiceImpl implements CompanyService {

    @Autowired
    private CompanyDao companyDao;

    @Autowired
    private PmsClient pmsClient;

    @Override
    public ResultBody addCompanyInfo(CompanyInfoVO companyInfo) {
        CompanyInfoDO companyInfoDO = new CompanyInfoDO(companyInfo);
        companyDao.addCompanyInfo(companyInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody removeCompanyInfo(Integer id, String token) {
        // 查询绑定账号数量是否大于0
        int backAccountCount = companyDao.countCompanyBackUser(id);
        if (backAccountCount > 0){
            return ResultBody.error(ResultEnum.REMOVE_COMPANY_BINDING_ERROR);
        }
        // 查询绑定服务数量是否大于0
        Integer taskCount = pmsClient.countCompanyTasks(id, token);
        if ( taskCount == null || taskCount > 0){
            return ResultBody.error(ResultEnum.REMOVE_COMPANY_TASK_ERROR);
        }
        companyDao.removeCompanyInfo(id);
        return ResultBody.success();
    }

    @Override
    public ResultBody updateCompanyInfo(CompanyInfoVO companyInfo) {
        CompanyInfoDO companyInfoDO = new CompanyInfoDO(companyInfo);
        companyDao.updateCompanyInfo(companyInfoDO);
        return ResultBody.success();
    }

    @Override
    public ResultBody getCompanyInfoById(Integer id) {
        CompanyInfoDO companyInfoDO = companyDao.getCompanyInfoById(id);
        if (companyInfoDO != null){
            return ResultBody.success(companyInfoDO.buildCompanyInfoVO());
        }
        return ResultBody.success();
    }

    @Override
    public ResultBody<CompanyInfoVO> listCompanyPage(CompanyInfoQO param, LoginSuccessDTO loginSuccessDTO) {
        CompanyInfoDO companyInfoDO = companyDao.getCompanyInfoByBackUserAccountId(loginSuccessDTO.getUserAccountId());
        if (companyInfoDO != null && !companyInfoDO.getCompanyType().equals(0)){
            param.setCompanyInfoId(companyInfoDO.getId());
        }
        int count = companyDao.countListCompanyPage(param);
        if (count == 0){
            return ResultBody.success(PageResult.buildPage(param.getPageNo(), param.getPageSize(), count));
        }
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<CompanyInfoDO> companyInfoDOS = companyDao.listCompanyPage(param);
        List<CompanyInfoVO> companyInfoVOList = companyInfoDOS.stream().map(CompanyInfoDO::buildCompanyInfoVO).collect(Collectors.toList());
        return ResultBody.success(PageResult.buildPage(pageNo, param.getPageSize(), count, companyInfoVOList));
    }

    @Override
    public CompanyInfoVO getCompanyInfoByBackUserAccountId(Integer backUserAccountId) {
        CompanyInfoDO companyInfoDO = companyDao.getCompanyInfoByBackUserAccountId(backUserAccountId);
        if (companyInfoDO != null) {
            return companyInfoDO.buildCompanyInfoVO();
        }
        return null;
    }

    @Override
    public void addCompanyBackUser(CompanyBackUserDO companyBackUserDO) {
        companyDao.addCompanyBackUser(companyBackUserDO);
    }

    @Override
    public void updateCompanyBackUser(CompanyBackUserDO companyBackUserDO) {
        companyDao.updateCompanyBackUser(companyBackUserDO);
    }
    @Override
    public List<CompanyInfoVO> listCompanyPageBack(CompanyInfoQO param) {
        Integer pageNo = param.getPageNo();
        param.buildCurrentPage();
        List<CompanyInfoDO> companyInfoDOS = companyDao.listCompanyPage(param);
        List<CompanyInfoVO> companyInfoVOList = companyInfoDOS.stream().map(CompanyInfoDO::buildCompanyInfoVO).collect(Collectors.toList());
        return companyInfoVOList;
    }

    @Override
    public List<CompanyInfoDO> listCompanyInfoByUID(List<Integer> backUserIds) {
        List<CompanyInfoDO> companyInfoDOList = companyDao.listCompanyInfoByUID(backUserIds);
        return companyInfoDOList;
    }
}
