package com.mmc.iuav.user.dao;

import com.mmc.iuav.user.entity.CompanyBackUserDO;
import com.mmc.iuav.user.entity.CompanyInfoDO;
import com.mmc.iuav.user.model.qo.CompanyInfoQO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: zj
 * @Date: 2023/7/3 15:39
 */
@Mapper
public interface CompanyDao {
    /**
     * 添加单位
     * @param companyInfoDO
     */
    void addCompanyInfo(CompanyInfoDO companyInfoDO);

    /**
     * 移除单位
     * @param id
     */
    void removeCompanyInfo(Integer id);

    /**
     * 修改单位
     * @param companyInfoDO
     */
    void updateCompanyInfo(CompanyInfoDO companyInfoDO);

    /**
     * 单位查询
     * @param id
     * @return
     */
    CompanyInfoDO getCompanyInfoById(Integer id);

    /**
     * 单位数量查询
     * @param param
     * @return
     */
    int countListCompanyPage(CompanyInfoQO param);

    /**
     * 单位列表
     * @param param
     * @return
     */
    List<CompanyInfoDO> listCompanyPage(CompanyInfoQO param);

    /**
     * 通过用户ID获取单位信息
     * @param backUserAccountId
     * @return
     */
    CompanyInfoDO getCompanyInfoByBackUserAccountId(Integer backUserAccountId);

    /**
     * 添加绑定关系
     * @param companyBackUserDO
     */
    void addCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    /**
     * 修改绑定关系
     * @param companyBackUserDO
     */
    void updateCompanyBackUser(CompanyBackUserDO companyBackUserDO);

    /**
     * 查询单位绑定的账号数量
     * @param id
     * @return
     */
    int countCompanyBackUser(Integer id);

    /**
     * 通过用户id获取单位信息
     * @param backUserIds
     * @return
     */
    List<CompanyInfoDO> listCompanyInfoByUID(@Param("backUserIds") List<Integer> backUserIds);
}
