package com.mmc.iuav.user.model.vo;

import com.mmc.iuav.group.Insert;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author: zj @Date: 2023/5/17 22:02
 */
@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserApplyTagVO implements Serializable {
  private static final long serialVersionUID = -1004953417393220972L;

  @ApiModelProperty(value = "id")
  private Integer id;

  @ApiModelProperty(value = "加盟标签id")
  @NotNull(
      message = "加盟标签id不能为空",
      groups = {Insert.class})
  private Integer cooperationTagId;

  @ApiModelProperty(value = "用户id")
  private Integer userAccountId;

  @ApiModelProperty(value = "申请人名称")
  @NotBlank(
      message = "申请人名称不能为空",
      groups = {Insert.class})
  private String applyName;

  @ApiModelProperty(value = "申请人手机号")
  @NotBlank(
      message = "申请人手机号不能为空",
      groups = {Insert.class})
  private String applyPhone;

  @ApiModelProperty(value = "备注")
  private String remark;

  @ApiModelProperty(value = "附件")
  private List<AttachmentVO> attachmentList;

  @ApiModelProperty(value = "申请时间")
  private Date applyTime;

  @ApiModelProperty(value = "加盟类型名称")
  private String cooperationTagName;

  @ApiModelProperty(value = "审批状态 0:申请中 1：通过  2：驳回")
  private Integer approvalStatus;
}
