package com.mmc.iuav.user.entity;

import com.mmc.iuav.user.model.dto.UserAccountSimpleDTO;
import com.mmc.iuav.user.model.vo.BUserAccountVO;
import com.mmc.iuav.user.model.vo.TopInviteVO;
import com.mmc.iuav.user.model.vo.UserAccountVO;
import com.mmc.iuav.user.model.vo.UserStateVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: zj
 * @Date: 2023/5/16 17:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserAccountDO implements Serializable {
    private static final long serialVersionUID = 5007589179946146721L;
    private Integer id;
    private Integer newId;
    private String uid;
    private String phoneNum;
    private String userName;
    private String nickName;
    private String userImg;
    private String openId;
    private String unionId;
    private Integer userSex;
    private String email;
    private Integer source;
    private Integer accountStatus;
    private String remark;
    private Integer portType;
    private Integer disable;
    private Date createTime;
    private Date updateTime;
    private Integer provinceCode;
    private Integer cityCode;
    private Integer districtCode;

    private Integer xzAuthStatus;

    private Integer companyAuthStatus;
    private String companyName;
    private Integer leader;
    /**
     * 实名认证状态
     */
    private Integer realNameAuthStatus;
    /**
     * 邀请人数
     */
    private Integer inviteCount;
    /**
     * 上级推荐人
     */
    private UserRcdDO userRcdDO;
    /**
     * 用户加盟标签
     */
    private List<CooperationTagDO> cooperationTagDOS;
    /**
     * 审核用户
     */
    private String operatorUserName;

    /**
     * 飞手审核状态
     *
     * @param auditStatus
     */
    private Integer auditStatus;

    private Integer totalPoints;

    @ApiModelProperty(value = "地区")
    private String region;
    @ApiModelProperty(value = "个人简介")
    private String briefIntroduction;
    @ApiModelProperty(value = "封面背景图")
    private String coverPicture;
    @ApiModelProperty(value = "地区id")
    private Integer districtChildId;
    //web端登录密码
    private String password;
    @ApiModelProperty(value = "用户状态")
    private Integer userStateId;
    @ApiModelProperty(value = "是否是飞手")
    private int isPilot;
    public UserAccountDO(UserAccountVO userAccountVO) {
        this.id = userAccountVO.getId();
        this.phoneNum = userAccountVO.getPhoneNum();
        this.userName = userAccountVO.getUserName();
        this.nickName = userAccountVO.getNickName();
        this.userImg = userAccountVO.getUserImg();
        this.userSex = userAccountVO.getUserSex();
        this.email = userAccountVO.getEmail();
        this.accountStatus = userAccountVO.getAccountStatus();
        this.remark = userAccountVO.getRemark();
        this.portType = userAccountVO.getPortType();
        this.userImg = userAccountVO.getUserImg();
        this.coverPicture = userAccountVO.getCoverPicture();
        this.nickName = userAccountVO.getNickName();
        this.districtChildId = userAccountVO.getDistrictChildId();
        this.briefIntroduction = userAccountVO.getBriefIntroduction();
        UserStateVO userStateVO = userAccountVO.getUserStateVO();
        if(userStateVO != null) {
            userStateId = userStateVO.getId();
            if(userStateId == 0) {
                this.userStateId = null;
            }else {
                this.userStateId = userStateId;
            }
        }

    }

    public UserAccountDO(BUserAccountVO bUserAccountVO) {
        this.id = bUserAccountVO.getId();
        this.phoneNum = bUserAccountVO.getPhoneNum();
        this.userName = bUserAccountVO.getUserName();
        this.email = bUserAccountVO.getEmail();
        this.accountStatus = bUserAccountVO.getAccountStatus();
        this.remark = bUserAccountVO.getRemark();
        this.provinceCode = bUserAccountVO.getProvinceCode();
        this.cityCode = bUserAccountVO.getCityCode();
        this.districtCode = bUserAccountVO.getDistrictCode();
    }

    public UserAccountVO buildUserAccountVO() {
        return UserAccountVO.builder().id(this.id).uid(this.id + "").phoneNum(this.phoneNum).userName(this.userName).nickName(this.nickName).userImg(this.userImg).openId(this.openId)
                .userSex(this.userSex).email(this.email).source(this.source).accountStatus(this.accountStatus).remark(this.remark).portType(this.portType).createTime(this.createTime)
                .companyAuthStatus(this.companyName == null ? 0 : 1).companyName(this.companyName)
                .inviteCount(this.inviteCount)
                .cooperationTagVOS(CollectionUtils.isEmpty(this.cooperationTagDOS) ? null : this.cooperationTagDOS.stream().map(CooperationTagDO::buildCooperationTagVO).collect(Collectors.toList()))
                .userRcdVO(this.userRcdDO == null ? null : this.userRcdDO.buildUserRcdVO())
                .leader(this.leader)
                .realNameAuthStatus(this.realNameAuthStatus)
                .xzAuthStatus(this.xzAuthStatus)
                .auditStatus(this.auditStatus)
                .totalPoints(this.totalPoints)
                .region(this.region)
                .briefIntroduction(this.briefIntroduction)
                .coverPicture(this.coverPicture)
                .districtChildId(this.districtChildId)
                .password(this.password)
                .build();
    }

    public UserAccountSimpleDTO buildUserAccountSimpleDTO() {
        return UserAccountSimpleDTO.builder().id(this.id).uid(this.id + "").phoneNum(this.phoneNum).userName(this.userName).nickName(this.nickName)
                .userImg(this.userImg).openid(this.openId).userSex(this.userSex).email(this.email).source(this.source).accountStatus(this.accountStatus).portType(this.portType)
                .companyAuthStatus(this.companyName == null ? 0 : 1).companyName(this.companyName)
                .region(this.region)
                .briefIntroduction(this.briefIntroduction)
                .coverPicture(this.coverPicture)
                .isPilot(this.isPilot)
                .build();
    }

    public TopInviteVO buildTopInviteVO() {
        return TopInviteVO.builder().id(this.id).uid(this.id + "").nickName(this.nickName).userName(this.userName).phoneNum(this.phoneNum)
                .inviteCount(this.inviteCount).userImg(this.userImg).build();
    }
    public UserDO buildUserDO() {
        return UserDO.builder().userAccountId(this.id).nickName(this.nickName).userName(this.userName).userImg(this.userImg).phoneNum(this.phoneNum).build();
    }

}
