package com.mmc.iuav.user.controller;

import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.user.model.dto.LoginSuccessDTO;
import com.mmc.iuav.user.model.qo.MessageQO;
import com.mmc.iuav.user.model.qo.MessageUserQO;
import com.mmc.iuav.user.model.vo.MessageTimePointsVO;
import com.mmc.iuav.user.model.vo.MessageTimeVO;
import com.mmc.iuav.user.model.vo.SystemMessageVO;
import com.mmc.iuav.user.model.vo.UserMessageVO;
import com.mmc.iuav.user.service.MessageService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

@Api(tags = "消息管理")
@RequestMapping("/message/")
@RestController
public class MessageController  extends BaseController{
    @Resource
    private MessageService messageService;

    @ApiOperation(value = "后台发布消息——新增系统消息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertSystemMessage")
    public ResultBody insertSystemMessage(@RequestBody SystemMessageVO messageVO){
        return messageService.insertSystemMessage(messageVO);
    }

    @ApiOperation(value = "后台——根据ID查询系统消息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/selectSystemMessageById")
    public ResultBody selectSystemMessageById(@ApiParam(value = "消息ID") @RequestParam Integer id){
        return messageService.selectSystemMessageById(id);
    }
    @ApiOperation(value = "后台——系统消息列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/selectAllSystemMessage")
    public ResultBody selectAllSystemMessage(@RequestBody MessageQO messageQO){
        return ResultBody.success(messageService.selectAllSystemMessage(messageQO));
    }

    @ApiOperation(value = "后台——删除消息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/removeMessage")
    public ResultBody removeMessage(@ApiParam(value = "消息ID") @RequestParam Integer id){
        return messageService.removeMessage(id);
    }

    @ApiOperation(value = "用户——系统消息列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/systemMessageListByUser")
    public ResultBody selectAllSystemMessageByUser(HttpServletRequest request,@RequestBody MessageQO messageQO){
        Integer userId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return ResultBody.success(messageService.selectAllSystemMessageByReceive(userId,messageQO));
    }
    @ApiOperation(value = "用户查看——系统消息详情")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/showSystemMessageByUser")
    public ResultBody showSystemMessageByUser(HttpServletRequest request,@ApiParam(value = "消息ID") @RequestParam Integer messageId){
        Integer userId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return messageService.showSystemMessageByUser(userId,messageId);
    }

    @ApiOperation(value = "用户——删除接收的消息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/removeMessageByUser")
    public ResultBody removeMessageByUser(HttpServletRequest request,@ApiParam(value = "消息ID") @RequestParam Integer messageId){
        Integer userId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        return messageService.removeMessageByUser(userId,messageId);
    }

    @ApiOperation(value = "用户发送消息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertUserMessage")
    public ResultBody insertUserMessage(HttpServletRequest request,@RequestBody UserMessageVO messageVO){
        return messageService.insertUserMessage(messageVO,this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "查看用户是否购买聊天")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/isPurchaseTime")
    public ResultBody isPurchaseTime(HttpServletRequest request){
        return messageService.isPurchaseTime(this.getUserLoginInfoFromRedis(request).getUserAccountId());
    }

    @ApiOperation(value = "用户聊天详细信息")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/selectUserMessage")
    public ResultBody selectUserMessage(HttpServletRequest request,@RequestBody MessageUserQO messageQO){
        return ResultBody.success(messageService.selectUserMessage(messageQO,this.getUserLoginInfoFromRedis(request).getUserAccountId()));
    }

    @ApiOperation(value = "用户列表")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/selectUserList")
    public ResultBody selectUserList(HttpServletRequest request,@RequestParam(required = false) Integer userAccountId){
        if(userAccountId==null){
            userAccountId = this.getUserLoginInfoFromRedis(request).getUserAccountId();
        }
        return messageService.selectUserList(userAccountId);
    }
    @ApiOperation(value = "用户列表——用户移除")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/removeUser")
    public ResultBody removeUser(HttpServletRequest request, @ApiParam(value = "接收人ID") @RequestParam Integer receiverUserId, @RequestParam(required = false) Integer backUserId) {
        return messageService.removeUser(this.getUserLoginInfoFromRedis(request).getUserAccountId(), receiverUserId, backUserId);
    }
    @ApiOperation(value = "用户撤回消息（三分钟之内可以撤回）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/removeUserMessage")
    public ResultBody removeUserMessage(@ApiParam(value = "消息ID") @RequestParam Integer id){
        return messageService.removeUserMessage(id);
    }

//    @ApiOperation(value = "购买聊天时长(积分或微信支付）")
//    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
//    @PostMapping("/purchaseTime")
//    public ResultBody purchaseTime(HttpServletRequest request,@RequestBody MessageTimeVO messageTimeVO){
//        LoginSuccessDTO userLoginInfoFromRedis = this.getUserLoginInfoFromRedis(request);
//        Integer userAccountId = userLoginInfoFromRedis.getUserAccountId();
//        String token = userLoginInfoFromRedis.getToken();
//        return messageService.purchaseTime(userAccountId,messageTimeVO,token);
//    }

    @ApiOperation(value = "购买聊天时长(积分）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/purchaseTimeByPoints")
    public ResultBody purchaseTimeByPoints(HttpServletRequest request,@RequestBody MessageTimePointsVO messageTimeVO){
        LoginSuccessDTO userLoginInfoFromRedis = this.getUserLoginInfoFromRedis(request);
        Integer userAccountId = userLoginInfoFromRedis.getUserAccountId();
        return messageService.purchaseTimeByPoints(userAccountId,messageTimeVO);
    }
    @ApiOperation(value = "购买聊天时长(微信支付成功）")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/purchaseTimeByWechat")
    public ResultBody purchaseTimeByWechat(HttpServletRequest request,@ApiParam(value = "购买聊天时长的类型id，唯一识别id", required = true) @RequestParam Integer typeId){
        LoginSuccessDTO userLoginInfoFromRedis = this.getUserLoginInfoFromRedis(request);
        Integer userAccountId = userLoginInfoFromRedis.getUserAccountId();
        return messageService.purchaseTimeByWechat(userAccountId,typeId);
    }
    @ApiOperation(value = "返回给小程序端聊天时长选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/listTimeType")
    public ResultBody listTimeType(){
        return messageService.listTimeType();
    }
    @ApiOperation(value = "后台管理——修改聊天时长选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/updateTimeType")
    public ResultBody updateTimeType(@RequestBody MessageTimeVO messageTimeVO){
        return messageService.updateTimeType(messageTimeVO);
    }
    @ApiOperation(value = "后台管理——新增聊天时长选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/insertTimeType")
    public ResultBody insertTimeType(@RequestBody MessageTimeVO messageTimeVO){
        return messageService.insertTimeType(messageTimeVO);
    }

    @ApiOperation(value = "根据类型ID返回聊天时长选购类型")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @GetMapping("/timeTypeById")
    public Integer timeTypeById(@ApiParam(value = "购买聊天时长的类型id，唯一识别id", required = true)  Integer typeId, Integer userId){
        return messageService.timeTypeById(typeId,userId);
    }

    @ApiOperation(value = "获取用户商家聊天次数")
    @ApiResponses({@ApiResponse(code = 200, message = "OK", response = ResultBody.class)})
    @PostMapping("/getUserMessageNum")
    public ResultBody getUserMessageNum(){
        return messageService.getUserMessageNum();
    }
}
