package com.mmc.iuav.user.client;


import com.mmc.iuav.response.ResultBody;
import com.mmc.iuav.response.ResultEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.List;

/**
 * @author Admin
 */
@Component
public class OmsClient {

    @Value("${iuav.oms.uri}")
    private String omsAppUri;

    @Autowired
    private RestTemplate restTemplate;

    public Object getCountNewOrder(Integer backUserId) {
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<String> entity = new HttpEntity<>(null, headers);
        ResponseEntity<ResultBody> responseEntity = restTemplate.exchange(omsAppUri + "/oms/uav-order/getCountNewOrder" + "?backUserId=" + backUserId, HttpMethod.GET, entity, ResultBody.class);
        ResultBody body = responseEntity.getBody();
        return body.getResult();

    }

}
